/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.vti.VTITemplate;

public class SampleVTI
extends VTITemplate {
    private static final String[][] oneColData = new String[][]{{"one"}, {"two"}, {"three"}, {"four"}, {"five"}};
    private final String[][] data;
    private final int rows;
    private final int cols;
    private int index = -1;
    private boolean wasNull;
    private boolean closed;

    public static ResultSet emptySampleVTI() {
        return new SampleVTI(new String[0][0]);
    }

    public static ResultSet oneColSampleVTI() {
        return new SampleVTI(oneColData);
    }

    public static String[][] oneColSampleVTIData() {
        return (String[][])oneColData.clone();
    }

    private SampleVTI(String[][] stringArray) {
        this.data = stringArray;
        this.rows = stringArray.length;
        this.cols = this.rows == 0 ? 0 : stringArray[0].length;
    }

    private String getColumn(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("result set closed");
        }
        if (n < 1 || n > this.cols) {
            throw new SQLException("column value out of range");
        }
        String string = this.data[this.index][n - 1];
        this.wasNull = string == null;
        return string;
    }

    public boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("result set closed");
        }
        return ++this.index < this.rows;
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public String getString(int n) throws SQLException {
        return this.getColumn(n);
    }

    public int getInt(int n) throws SQLException {
        String string = this.getColumn(n);
        if (this.wasNull) {
            string = "0";
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("cannot get value as int");
        }
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

