/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.net.URI;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

class UpgradeRequestDelegate
implements UpgradeRequest {
    private final ServerUpgradeRequest request;
    private final Map<String, List<String>> headers;

    UpgradeRequestDelegate(ServerUpgradeRequest request) {
        this.request = request;
        this.headers = HttpFields.asMap(request.getHeaders());
    }

    @Override
    public List<java.net.HttpCookie> getCookies() {
        return Request.getCookies(this.request).stream().map(HttpCookie::asJavaNetHttpCookie).toList();
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.request.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeaders().get(name);
    }

    @Override
    public int getHeaderInt(String name) {
        return (int)this.request.getHeaders().getLongField(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.request.getHeaders().getValuesList(name);
    }

    @Override
    public String getHost() {
        return this.request.getHttpURI().getHost();
    }

    @Override
    public String getHttpVersion() {
        return this.request.getConnectionMetaData().getHttpVersion().asString();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getOrigin() {
        return this.request.getHeaders().get(HttpHeader.ORIGIN);
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        Fields fields = Request.extractQueryParameters(this.request);
        for (Fields.Field field : fields) {
            result.put(field.getName(), field.getValues());
        }
        return result;
    }

    @Override
    public String getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    @Override
    public String getQueryString() {
        return this.request.getHttpURI().getQuery();
    }

    @Override
    public URI getRequestURI() {
        HttpURI httpURI = this.request.getHttpURI();
        HttpURI.Mutable wsURI = HttpURI.build(httpURI);
        wsURI.scheme(HttpScheme.isSecure(httpURI.getScheme()) ? HttpScheme.WSS : HttpScheme.WS);
        return wsURI.toURI();
    }

    @Override
    public List<String> getSubProtocols() {
        return this.request.getSubProtocols();
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public boolean hasSubProtocol(String subProtocol) {
        return this.request.hasSubProtocol(subProtocol);
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }
}

