/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.grails.datastore.bson.codecs

import org.bson.BsonReader
import org.bson.codecs.DecoderContext
import org.bson.codecs.configuration.CodecRegistry

import org.grails.datastore.mapping.engine.EntityAccess
import org.grails.datastore.mapping.model.PersistentProperty

/**
 * An interface for encoding PersistentProperty instances
 *
 * @author Graeme Rocher
 * @since 6.0
 */
interface PropertyDecoder<T extends PersistentProperty> {

    /**
     * Decodes a persistent property using the given reader
     *
     * @param reader The {@link BsonReader}
     * @param property The property
     * @param entityAccess Access to the entity
     * @param decoderContext The decoder context
     * @param codecRegistry The code registry
     */
    void decode(BsonReader reader, T property, EntityAccess entityAccess, DecoderContext decoderContext, CodecRegistry codecRegistry)
}
