/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.SourceLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SourceFolderLibrary
extends SourceLibrary {
    private List<File> sourceFolders = new LinkedList<File>();

    public SourceFolderLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public SourceFolderLibrary(AbstractClassLibrary parent, File sourceFolder) {
        super(parent);
        this.sourceFolders.add(sourceFolder);
    }

    public JavaModule addSourceFolder(File sourceFolder) {
        this.sourceFolders.add(sourceFolder);
        return this.resolveJavaModule(sourceFolder);
    }

    @Override
    public Collection<JavaModule> getJavaModules() {
        return this.resolveJavaModules();
    }

    private Collection<JavaModule> resolveJavaModules() {
        ArrayList<JavaModule> modules = new ArrayList<JavaModule>(this.sourceFolders.size());
        for (File sourceFolder : this.sourceFolders) {
            JavaModule module = this.resolveJavaModule(sourceFolder);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    private JavaModule resolveJavaModule(File sourceFolder) {
        JavaModule result = null;
        File moduleInfoFile = new File(sourceFolder, "module-info.java");
        if (moduleInfoFile.isFile()) {
            try {
                result = this.parse(new FileReader(moduleInfoFile), moduleInfoFile.toURI().toURL()).getModuleInfo();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected JavaClass resolveJavaClass(String className) {
        JavaClass result = super.resolveJavaClass(className);
        String mainClassName = className.split("\\$")[0];
        File sourceFile = this.getSourceFile(mainClassName);
        if (sourceFile != null) {
            result = this.getClassFromSourceFile(sourceFile, className);
        }
        return result;
    }

    @Override
    protected boolean containsClassReference(String className) {
        String mainClassName;
        File sourceFile;
        boolean result = super.containsClassReference(className);
        if (!result && (sourceFile = this.getSourceFile(mainClassName = className.split("\\$")[0])) != null) {
            result = mainClassName.equals(className) ? true : this.getClassFromSourceFile(sourceFile, className) != null;
        }
        return result;
    }

    private File getSourceFile(String mainClassName) {
        for (File sourceFolder : this.sourceFolders) {
            File classFile = new File(sourceFolder, mainClassName.replace('.', File.separatorChar) + ".java");
            if (!classFile.isFile()) continue;
            return classFile;
        }
        return null;
    }

    private JavaClass getClassFromSourceFile(File sourceFile, String className) {
        try {
            JavaSource source = this.parse(new FileReader(sourceFile), sourceFile.toURI().toURL()).getSource();
            return source.getClassByName(className);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

