/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.session;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.rest.session.UserContextResource;
import org.apache.guacamole.rest.session.UserContextResourceFactory;
import org.apache.guacamole.rest.tunnel.TunnelCollectionResource;
import org.apache.guacamole.rest.tunnel.TunnelCollectionResourceFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SessionResource {
    private final GuacamoleSession session;
    private final String token;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private UserContextResourceFactory userContextResourceFactory;
    @Inject
    private TunnelCollectionResourceFactory tunnelCollectionResourceFactory;

    @AssistedInject
    public SessionResource(@Assisted String token, @Assisted GuacamoleSession session) {
        this.token = token;
        this.session = session;
    }

    @Path(value="data/{dataSource}")
    public UserContextResource getUserContextResource(@PathParam(value="dataSource") String authProviderIdentifier) throws GuacamoleException {
        DecoratedUserContext userContext = this.session.getUserContext(authProviderIdentifier);
        return this.userContextResourceFactory.create(this.session.getAuthenticatedUser(), (UserContext)userContext);
    }

    @Path(value="ext/{dataSource}")
    public Object getExtensionResource(@PathParam(value="dataSource") String authProviderIdentifier) throws GuacamoleException {
        DecoratedUserContext userContext = this.session.getUserContext(authProviderIdentifier);
        Object resource = userContext.getResource();
        if (resource != null) {
            return resource;
        }
        throw new GuacamoleResourceNotFoundException("No such resource.");
    }

    @Path(value="tunnels")
    public TunnelCollectionResource getTunnelCollectionResource() {
        return this.tunnelCollectionResourceFactory.create(this.session);
    }

    @DELETE
    public void invalidate() throws GuacamoleException {
        if (!this.authenticationService.destroyGuacamoleSession(this.token)) {
            throw new GuacamoleResourceNotFoundException("No such token.");
        }
    }

    @HEAD
    public void checkValidity() {
    }
}

