/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdMinRowCount
implements MetadataHandler<BuiltInMetadata.MinRowCount> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdMinRowCount(), BuiltInMetadata.MinRowCount.Handler.class);

    @Override
    public MetadataDef<BuiltInMetadata.MinRowCount> getDef() {
        return BuiltInMetadata.MinRowCount.DEF;
    }

    public Double getMinRowCount(Union rel, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getMinRowCount(input);
            if (partialRowCount == null) continue;
            rowCount += partialRowCount.doubleValue();
        }
        if (rel.all) {
            return rowCount;
        }
        return Math.min(rowCount, 1.0);
    }

    public Double getMinRowCount(Intersect rel, RelMetadataQuery mq) {
        return 0.0;
    }

    public Double getMinRowCount(Minus rel, RelMetadataQuery mq) {
        return 0.0;
    }

    public Double getMinRowCount(Filter rel, RelMetadataQuery mq) {
        return 0.0;
    }

    public @Nullable Double getMinRowCount(Calc rel, RelMetadataQuery mq) {
        if (rel.getProgram().getCondition() != null) {
            return 0.0;
        }
        return mq.getMinRowCount(rel.getInput());
    }

    public @Nullable Double getMinRowCount(Project rel, RelMetadataQuery mq) {
        return mq.getMinRowCount(rel.getInput());
    }

    public @Nullable Double getMinRowCount(Exchange rel, RelMetadataQuery mq) {
        return mq.getMinRowCount(rel.getInput());
    }

    public @Nullable Double getMinRowCount(TableModify rel, RelMetadataQuery mq) {
        return mq.getMinRowCount(rel.getInput());
    }

    public Double getMinRowCount(Sort rel, RelMetadataQuery mq) {
        Double rowCount = mq.getMinRowCount(rel.getInput());
        if (rowCount == null) {
            rowCount = 0.0;
        }
        int offset = rel.offset instanceof RexLiteral ? RexLiteral.intValue(rel.offset) : 0;
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        double limit = rel.fetch instanceof RexLiteral ? (double)RexLiteral.intValue(rel.fetch) : rowCount;
        return limit < rowCount ? limit : rowCount;
    }

    public Double getMinRowCount(EnumerableLimit rel, RelMetadataQuery mq) {
        Double rowCount = mq.getMinRowCount(rel.getInput());
        if (rowCount == null) {
            rowCount = 0.0;
        }
        int offset = rel.offset instanceof RexLiteral ? RexLiteral.intValue(rel.offset) : 0;
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        double limit = rel.fetch instanceof RexLiteral ? (double)RexLiteral.intValue(rel.fetch) : rowCount;
        return limit < rowCount ? limit : rowCount;
    }

    public Double getMinRowCount(Aggregate rel, RelMetadataQuery mq) {
        if (rel.getGroupSet().isEmpty()) {
            return 1.0;
        }
        Double rowCount = mq.getMinRowCount(rel.getInput());
        if (rowCount != null && rowCount >= 1.0) {
            return rel.getGroupSets().size();
        }
        return 0.0;
    }

    public Double getMinRowCount(Join rel, RelMetadataQuery mq) {
        return 0.0;
    }

    public @Nullable Double getMinRowCount(TableScan rel, RelMetadataQuery mq) {
        BuiltInMetadata.MinRowCount.Handler handler = rel.getTable().unwrap(BuiltInMetadata.MinRowCount.Handler.class);
        if (handler != null) {
            return handler.getMinRowCount(rel, mq);
        }
        return 0.0;
    }

    public Double getMinRowCount(Values values, RelMetadataQuery mq) {
        return values.getTuples().size();
    }

    public Double getMinRowCount(RelSubset rel, RelMetadataQuery mq) {
        Util.discard(false);
        for (RelNode node : rel.getRels()) {
            if (!(node instanceof Sort)) continue;
            Sort sort = (Sort)node;
            if (sort.fetch == null) continue;
            return RexLiteral.intValue(sort.fetch);
        }
        return 0.0;
    }

    public @Nullable Double getMinRowCount(RelNode rel, RelMetadataQuery mq) {
        return null;
    }
}

