/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.rest.api.cluster.ClusterTag;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Information about current cluster state.")
public class ClusterState {
    @Schema(description="List of cluster management group nodes. These nodes are responsible for maintaining RAFT cluster topology.")
    @IgniteToStringInclude
    private final Collection<String> cmgNodes;
    @Schema(description="List of metastorage nodes. These nodes are responsible for storing RAFT cluster metadata.")
    @IgniteToStringInclude
    private final Collection<String> msNodes;
    @Schema(description="Version of Apache Ignite that the cluster was created on.")
    private final String igniteVersion;
    @Schema(description="Unique tag that identifies the cluster.")
    private final ClusterTag clusterTag;
    @Schema(description="IDs the cluster had before.")
    @IgniteToStringInclude
    @Nullable
    private final List<UUID> formerClusterIds;

    @JsonCreator
    public ClusterState(@JsonProperty(value="cmgNodes") Collection<String> cmgNodes, @JsonProperty(value="msNodes") Collection<String> msNodes, @JsonProperty(value="igniteVersion") String igniteVersion, @JsonProperty(value="clusterTag") ClusterTag clusterTag, @JsonProperty(value="formerClusterIds") @Nullable List<UUID> formerClusterIds) {
        this.cmgNodes = List.copyOf(cmgNodes);
        this.msNodes = List.copyOf(msNodes);
        this.igniteVersion = igniteVersion;
        this.clusterTag = clusterTag;
        this.formerClusterIds = formerClusterIds == null ? null : List.copyOf(formerClusterIds);
    }

    @JsonGetter(value="cmgNodes")
    public Collection<String> cmgNodes() {
        return this.cmgNodes;
    }

    @JsonGetter(value="msNodes")
    public Collection<String> msNodes() {
        return this.msNodes;
    }

    @JsonGetter(value="igniteVersion")
    public String igniteVersion() {
        return this.igniteVersion;
    }

    @JsonGetter(value="clusterTag")
    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    @JsonGetter(value="formerClusterIds")
    @Nullable
    public List<UUID> formerClusterIds() {
        return this.formerClusterIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterState state = (ClusterState)o;
        return this.cmgNodes.equals(state.cmgNodes) && this.msNodes.equals(state.msNodes) && this.igniteVersion.equals(state.igniteVersion) && this.clusterTag.equals(state.clusterTag);
    }

    public int hashCode() {
        return Objects.hash(this.cmgNodes, this.msNodes, this.igniteVersion, this.clusterTag);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

