/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RuntimeHashIndex;
import org.apache.ignite.internal.sql.engine.exec.RuntimeIndex;
import org.apache.ignite.internal.sql.engine.exec.RuntimeSortedIndex;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.ScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class IndexSpoolNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final ScanNode<RowT> scan;
    private final RuntimeIndex<RowT> idx;
    private int requested;
    private int waiting;

    private IndexSpoolNode(ExecutionContext<RowT> ctx, RuntimeIndex<RowT> idx, ScanNode<RowT> scan) {
        super(ctx);
        this.idx = idx;
        this.scan = scan;
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        this.scan.onRegister(downstream);
    }

    @Override
    public Downstream<RowT> downstream() {
        return this.scan.downstream();
    }

    @Override
    protected void rewindInternal() {
        this.scan.rewind();
    }

    @Override
    public void rewind() {
        this.rewindInternal();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        this.checkState();
        if (!this.indexReady()) {
            this.requested = rowsCnt;
            this.requestSource();
        } else {
            this.scan.request(rowsCnt);
        }
    }

    private void requestSource() throws Exception {
        this.waiting = 512;
        this.source().request(512);
    }

    @Override
    public void push(RowT row) throws Exception {
        this.checkState();
        this.idx.push(row);
        --this.waiting;
        if (this.waiting == 0) {
            this.context().execute(this::requestSource, this::onError);
        }
    }

    @Override
    public void end() throws Exception {
        this.checkState();
        this.waiting = -1;
        this.scan.request(this.requested);
    }

    @Override
    protected void closeInternal() {
        try {
            this.scan.close();
        }
        catch (Exception ex) {
            this.onError(ex);
        }
        try {
            this.idx.close();
        }
        catch (RuntimeException ex) {
            this.onError(ex);
        }
        super.closeInternal();
    }

    private boolean indexReady() {
        return this.waiting == -1;
    }

    public static <RowT> IndexSpoolNode<RowT> createTreeSpool(ExecutionContext<RowT> ctx, RelDataType rowType, RelCollation collation, Comparator<RowT> comp, Predicate<RowT> filter, RangeIterable<RowT> ranges) {
        RuntimeSortedIndex<RowT> idx = new RuntimeSortedIndex<RowT>(ctx, collation, comp);
        ScanNode<RowT> scan = new ScanNode<RowT>(ctx, idx.scan(ctx, rowType, filter, ranges));
        return new IndexSpoolNode<RowT>(ctx, idx, scan);
    }

    public static <RowT> IndexSpoolNode<RowT> createHashSpool(ExecutionContext<RowT> ctx, ImmutableBitSet keys, @Nullable Predicate<RowT> filter, Supplier<RowT> searchRow, boolean allowNulls) {
        RuntimeHashIndex<RowT> idx = new RuntimeHashIndex<RowT>(ctx, keys, allowNulls);
        ScanNode<RowT> scan = new ScanNode<RowT>(ctx, idx.scan(searchRow, filter));
        return new IndexSpoolNode<RowT>(ctx, idx, scan);
    }
}

