/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class GetLeaderRequestProcessor
extends BaseCliRequestProcessor<CliRequests.GetLeaderRequest> {
    public GetLeaderRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.GetLeaderRequest request) {
        return request.peerId();
    }

    @Override
    protected String getGroupId(CliRequests.GetLeaderRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.GetLeaderRequest request, IgniteCliRpcRequestClosure done) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Message processRequest(CliRequests.GetLeaderRequest request, RpcRequestClosure done) {
        List<Object> nodes = new ArrayList();
        String groupId = this.getGroupId(request);
        if (request.peerId() != null) {
            PeerId peerId = new PeerId();
            String peerIdStr = this.getPeerId(request);
            if (!peerId.parse(peerIdStr)) return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
            Status st = new Status();
            nodes.add(this.getNode(groupId, peerId, st, done.getRpcCtx().getNodeManager()));
            if (!st.isOk()) {
                return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), st);
            }
        } else {
            nodes = done.getRpcCtx().getNodeManager().getNodesByGroupId(groupId);
        }
        if (nodes == null || nodes.isEmpty()) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.ENOENT, "No nodes in group %s", groupId);
        }
        for (Node node : nodes) {
            PeerId leader = node.getLeaderId();
            if (leader == null || leader.isEmpty()) continue;
            return this.msgFactory().getLeaderResponse().leaderId(leader.toString()).currentTerm(node.getCurrentTerm()).build();
        }
        return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.UNKNOWN, "Unknown leader", new Object[0]);
    }

    @Override
    public String interest() {
        return CliRequests.GetLeaderRequest.class.getName();
    }
}

