/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum DeploymentStatus {
    UPLOADING("UPLOADING"),
    DEPLOYED("DEPLOYED"),
    OBSOLETE("OBSOLETE"),
    REMOVING("REMOVING");

    private String value;

    private DeploymentStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentStatus fromValue(String value) {
        for (DeploymentStatus b : DeploymentStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        DeploymentStatus.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<DeploymentStatus> {
        public void write(JsonWriter jsonWriter, DeploymentStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public DeploymentStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return DeploymentStatus.fromValue(value);
        }
    }
}

