/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public class PlatformComputeTaskSession
extends PlatformAbstractTarget {
    private static final int OP_GET_ATTRIBUTE = 1;
    private static final int OP_SET_ATTRIBUTES = 2;
    private final ComputeTaskSession ses;

    public PlatformComputeTaskSession(PlatformContext platformCtx, ComputeTaskSession ses) {
        super(platformCtx);
        this.ses = ses;
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader, PlatformMemory mem) throws IgniteCheckedException {
        if (type == 2) {
            Map attrs = PlatformUtils.readMap(reader);
            this.ses.setAttributes(attrs);
            return 1L;
        }
        return super.processInStreamOutLong(type, reader, mem);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 1) {
            Object key = reader.readObjectDetached();
            Object val = this.ses.getAttribute(key);
            writer.writeObjectDetached(val);
            return;
        }
        super.processInStreamOutStream(type, reader, writer);
    }
}

