/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemander;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplier;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDhtPreloader
extends GridCachePreloaderAdapter {
    public static final long DFLT_PRELOAD_RESEND_TIMEOUT = 1500L;
    private final boolean disableRebalancingCancellationOptimization = IgniteSystemProperties.getBoolean("IGNITE_DISABLE_REBALANCING_CANCELLATION_OPTIMIZATION");
    private GridDhtPartitionTopology top;
    private GridDhtPartitionSupplier supplier;
    private GridDhtPartitionDemander demander;
    private GridFutureAdapter<Object> startFut;
    private final ReadWriteLock busyLock = new ReentrantReadWriteLock();
    private boolean stopped;

    public GridDhtPreloader(CacheGroupContext grp) {
        super(grp);
        this.top = grp.topology();
        this.startFut = new GridFutureAdapter();
    }

    @Override
    public void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting DHT rebalancer...");
        }
        this.supplier = new GridDhtPartitionSupplier(this.grp);
        this.demander = new GridDhtPartitionDemander(this.grp);
        this.demander.start();
    }

    @Override
    public void onKernalStop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DHT rebalancer onKernalStop callback.");
        }
        this.pause();
        try {
            if (this.supplier != null) {
                this.supplier.stop();
            }
            if (this.demander != null) {
                this.demander.stop();
            }
            this.top = null;
            this.stopped = true;
        }
        finally {
            this.resume();
        }
    }

    private IgniteCheckedException stopError() {
        return new NodeStoppingException("Operation has been cancelled (cache or node is stopping).");
    }

    public boolean disableRebalancingCancellationOptimization() {
        return this.disableRebalancingCancellationOptimization;
    }

    @Override
    public void onInitialExchangeComplete(@Nullable Throwable err) {
        if (err == null) {
            this.startFut.onDone();
        } else {
            this.startFut.onDone(err);
        }
    }

    @Override
    public void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.supplier.onTopologyChanged();
        this.demander.onTopologyChanged(lastFut);
    }

    @Override
    public boolean rebalanceRequired(GridDhtPartitionsExchangeFuture exchFut) {
        if (this.ctx.kernalContext().clientNode()) {
            return false;
        }
        AffinityTopologyVersion lastAffChangeTopVer = this.ctx.exchange().lastAffinityChangedTopologyVersion(exchFut.topologyVersion());
        return lastAffChangeTopVer.equals(exchFut.topologyVersion());
    }

    @Override
    public GridDhtPreloaderAssignments generateAssignments(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture exchFut) {
        assert (exchFut == null || exchFut.isDone());
        GridDhtPartitionTopology top = this.grp.topology();
        if (!this.grp.rebalanceEnabled()) {
            return new GridDhtPreloaderAssignments(exchId, top.readyTopologyVersion(), false);
        }
        int partitions = this.grp.affinity().partitions();
        AffinityTopologyVersion topVer = top.readyTopologyVersion();
        assert (exchFut == null || exchFut.context().events().topologyVersion().equals(top.readyTopologyVersion()) || exchFut.context().events().topologyVersion().equals(this.ctx.exchange().lastAffinityChangedTopologyVersion(top.readyTopologyVersion()))) : "Topology version mismatch [exchId=" + exchId + ", grp=" + this.grp.name() + ", topVer=" + top.readyTopologyVersion() + ']';
        GridDhtPreloaderAssignments assignments = new GridDhtPreloaderAssignments(exchId, topVer, exchFut != null && exchFut.affinityReassign());
        AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
        CachePartitionFullCountersMap countersMap = this.grp.topology().fullUpdateCounters();
        for (int p = 0; p < partitions; ++p) {
            List<UUID> nodeIds;
            if (this.ctx.exchange().hasPendingServerExchange()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping assignments creation, exchange worker has pending assignments: " + exchId);
                }
                assignments.cancelled(true);
                return assignments;
            }
            if (!aff.get(p).contains(this.ctx.localNode())) continue;
            GridDhtLocalPartition part = top.localPartition(p);
            assert (part != null);
            assert (part.id() == p);
            if (part.state() == GridDhtPartitionState.OWNING || part.state() == GridDhtPartitionState.LOST) continue;
            if (part.state() != GridDhtPartitionState.MOVING) {
                throw new AssertionError((Object)("Partition has invalid state for rebalance " + aff.topologyVersion() + " " + part));
            }
            ClusterNode histSupplier = null;
            if (this.grp.persistenceEnabled() && exchFut != null && !F.isEmpty(nodeIds = exchFut.partitionHistorySupplier(this.grp.groupId(), p, part.initialUpdateCounter()))) {
                histSupplier = this.ctx.discovery().node(nodeIds.get(p % nodeIds.size()));
            }
            if (histSupplier != null && !exchFut.isClearingPartition(this.grp, p)) {
                assert (this.grp.persistenceEnabled());
                assert (this.remoteOwners(p, topVer).contains(histSupplier)) : this.remoteOwners(p, topVer);
                GridDhtPartitionDemandMessage msg = (GridDhtPartitionDemandMessage)assignments.get(histSupplier);
                if (msg == null) {
                    msg = new GridDhtPartitionDemandMessage(top.updateSequence(), assignments.topologyVersion(), this.grp.groupId());
                    assignments.put(histSupplier, msg);
                }
                msg.partitions().addHistorical(p, part.initialUpdateCounter(), countersMap.updateCounter(p), partitions);
                continue;
            }
            int partId = p;
            List<ClusterNode> picked = this.remoteOwners(p, topVer, node -> exchFut == null || exchFut.isNodeApplicableForFullRebalance(node.id(), this.grp.groupId(), partId));
            if (picked.isEmpty()) continue;
            ClusterNode n = picked.get(p % picked.size());
            GridDhtPartitionDemandMessage msg = (GridDhtPartitionDemandMessage)assignments.get(n);
            if (msg == null) {
                msg = new GridDhtPartitionDemandMessage(top.updateSequence(), assignments.topologyVersion(), this.grp.groupId());
                assignments.put(n, msg);
            }
            msg.partitions().addFull(p);
        }
        if (!assignments.isEmpty()) {
            if (exchFut != null && exchFut.rebalanced()) {
                GridDhtPartitionDemandMessage first = (GridDhtPartitionDemandMessage)assignments.values().iterator().next();
                GridDhtLocalPartition locPart = this.grp.topology().localPartition(first.partitions().all().iterator().next());
                SB buf = new SB(1024);
                buf.a("Unexpected rebalance on rebalanced cluster: assignments=");
                buf.a(assignments);
                buf.a(", locPart=");
                if (locPart != null) {
                    locPart.dumpDebugInfo(buf);
                } else {
                    buf.a("NA");
                }
                throw new AssertionError((Object)buf.toString());
            }
            this.ctx.database().lastCheckpointInapplicableForWalRebalance(this.grp.groupId());
        }
        return assignments;
    }

    @Override
    public void onReconnected() {
        this.startFut = new GridFutureAdapter();
    }

    private List<ClusterNode> remoteOwners(int p, AffinityTopologyVersion topVer) {
        return this.remoteOwners(p, topVer, node -> true);
    }

    private List<ClusterNode> remoteOwners(int p, AffinityTopologyVersion topVer, IgnitePredicate<ClusterNode> pred) {
        List<ClusterNode> owners = this.grp.topology().owners(p, topVer);
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(owners.size());
        for (ClusterNode owner : owners) {
            if (owner.id().equals(this.ctx.localNodeId()) || !pred.apply(owner)) continue;
            res.add(owner);
        }
        return res;
    }

    @Override
    public void handleSupplyMessage(UUID nodeId, GridDhtPartitionSupplyMessage s) {
        this.demander.registerSupplyMessage(nodeId, s, () -> {
            if (!this.enterBusy()) {
                return;
            }
            try {
                this.demander.handleSupplyMessage(nodeId, s);
            }
            finally {
                this.leaveBusy();
            }
        });
    }

    @Override
    public void handleDemandMessage(int idx, UUID nodeId, GridDhtPartitionDemandMessage d) {
        this.ctx.kernalContext().getStripedRebalanceExecutorService().execute(() -> {
            if (!this.enterBusy()) {
                return;
            }
            try {
                this.supplier.handleDemandMessage(idx, nodeId, d);
            }
            finally {
                this.leaveBusy();
            }
        }, Math.abs(nodeId.hashCode()));
    }

    @Override
    public GridDhtPartitionDemander.RebalanceFuture addAssignments(GridDhtPreloaderAssignments assignments, boolean forceRebalance, long rebalanceId, GridDhtPartitionDemander.RebalanceFuture next, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut, GridCompoundFuture<Boolean, Boolean> compatibleRebFut) {
        return this.demander.addAssignments(assignments, forceRebalance, rebalanceId, next, forcedRebFut, compatibleRebFut);
    }

    @Override
    public IgniteInternalFuture<Object> startFuture() {
        return this.startFut;
    }

    @Override
    public IgniteInternalFuture<?> syncFuture() {
        return this.ctx.kernalContext().clientNode() ? this.startFut : this.demander.syncFuture();
    }

    @Override
    public IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.ctx.kernalContext().clientNode() ? new GridFinishedFuture<Boolean>(true) : this.demander.rebalanceFuture();
    }

    private boolean enterBusy() {
        this.busyLock.readLock().lock();
        if (this.stopped) {
            this.busyLock.readLock().unlock();
            return false;
        }
        return true;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    public void tryFinishEviction(GridDhtLocalPartition part) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.top.tryFinishEviction(part) && this.grp.eventRecordable(83)) {
                this.grp.addUnloadEvent(part.id());
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean needForceKeys() {
        IgniteInternalFuture<Boolean> rebalanceFut;
        if (this.grp.mvccEnabled()) {
            return false;
        }
        return !this.grp.rebalanceEnabled() || !(rebalanceFut = this.rebalanceFuture()).isDone() || !Boolean.TRUE.equals(rebalanceFut.result());
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext cctx, GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) {
        if (!this.needForceKeys()) {
            return null;
        }
        return this.request0(cctx, req.keys(), topVer);
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext cctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        if (!this.needForceKeys()) {
            return null;
        }
        return this.request0(cctx, keys, topVer);
    }

    private GridDhtFuture<Object> request0(GridCacheContext cctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        if (cctx.isNear()) {
            cctx = cctx.near().dht().context();
        }
        final GridDhtForceKeysFuture fut = new GridDhtForceKeysFuture(cctx, topVer, keys);
        IgniteInternalFuture<AffinityTopologyVersion> topReadyFut = cctx.affinity().affinityReadyFuturex(topVer);
        if (this.startFut.isDone() && topReadyFut == null) {
            fut.init();
        } else if (topReadyFut == null) {
            this.startFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> syncFut) {
                    GridDhtPreloader.this.ctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            fut.init();
                        }
                    });
                }
            });
        } else {
            GridCompoundFuture compound = new GridCompoundFuture();
            compound.add(this.startFut);
            compound.add(topReadyFut);
            compound.markInitialized();
            compound.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> syncFut) {
                    fut.init();
                }
            });
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<Boolean> forceRebalance() {
        if (!this.enterBusy()) {
            return new GridFinishedFuture<Boolean>();
        }
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.demander.forceRebalance();
            return igniteInternalFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public void pause() {
        this.busyLock.writeLock().lock();
    }

    @Override
    public void resume() {
        this.busyLock.writeLock().unlock();
    }

    @Override
    public void finishPreloading(AffinityTopologyVersion topVer) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.demander.finishPreloading(topVer);
        }
        finally {
            this.leaveBusy();
        }
    }

    public GridDhtPartitionSupplier supplier() {
        return this.supplier;
    }

    public void supplier(GridDhtPartitionSupplier supplier) {
        this.supplier = supplier;
    }

    public GridDhtPartitionDemander demander() {
        return this.demander;
    }

    public void demander(GridDhtPartitionDemander demander) {
        this.demander = demander;
    }
}

