/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.closure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobMasterLeaveAware;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridInternalWrapper;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.closure.AffinityTask;
import org.apache.ignite.internal.processors.closure.GridPeerDeployAwareTaskAdapter;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.resource.GridNoImplicitInjection;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerFuture;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.resources.LoadBalancerResource;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridClosureProcessor
extends GridProcessorAdapter {
    private final PoolProcessor pools;
    private final GridSpinReadWriteLock busyLock = new GridSpinReadWriteLock();
    private boolean stopping;

    public GridClosureProcessor(GridKernalContext ctx) {
        super(ctx);
        this.pools = ctx.pools();
        assert (this.pools != null);
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started closure processor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop(boolean cancel) {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.busyLock.tryWriteLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        try {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.stopping = true;
        }
        finally {
            this.busyLock.writeUnlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped closure processor.");
        }
    }

    public ComputeTaskInternalFuture<?> runAsync(GridClosureCallMode mode, @Nullable Collection<? extends Runnable> jobs, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        return this.runAsync(mode, jobs, nodes, false, execName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeTaskInternalFuture<?> runAsync(GridClosureCallMode mode, Collection<? extends Runnable> jobs, @Nullable Collection<ClusterNode> nodes, boolean sys, @Nullable String execName) {
        assert (mode != null);
        assert (!F.isEmpty(jobs)) : jobs;
        this.busyLock.readLock();
        try {
            if (this.stopping) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T1.class, new IgniteCheckedException("Closure processor cannot be used on stopped grid: " + this.ctx.igniteInstanceName()));
                return computeTaskInternalFuture;
            }
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T1.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Void> computeTaskInternalFuture = this.ctx.task().execute(new T1(mode, jobs), null, sys, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public ComputeTaskInternalFuture<?> runAsync(GridClosureCallMode mode, Runnable job, @Nullable Collection<ClusterNode> nodes) {
        return this.runAsync(mode, job, nodes, null);
    }

    public ComputeTaskInternalFuture<?> runAsync(GridClosureCallMode mode, Runnable job, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        return this.runAsync(mode, job, nodes, false, execName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeTaskInternalFuture<?> runAsync(GridClosureCallMode mode, Runnable job, @Nullable Collection<ClusterNode> nodes, boolean sys, @Nullable String execName) {
        assert (mode != null);
        assert (job != null);
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T2.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Void> computeTaskInternalFuture = this.ctx.task().execute(new T2(mode, job), null, sys, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    private Map<ComputeJob, ClusterNode> absMap(GridClosureCallMode mode, Collection<? extends Runnable> jobs, Collection<ClusterNode> nodes, ComputeLoadBalancer lb) throws IgniteException {
        assert (mode != null);
        assert (jobs != null);
        assert (nodes != null);
        assert (lb != null);
        try {
            if (!F.isEmpty(jobs) && !F.isEmpty(nodes)) {
                JobMapper mapper = new JobMapper(jobs.size());
                switch (mode) {
                    case BROADCAST: {
                        for (ClusterNode clusterNode : nodes) {
                            for (Runnable runnable : jobs) {
                                mapper.map(GridClosureProcessor.job(runnable), clusterNode);
                            }
                        }
                        break;
                    }
                    case BALANCE: {
                        for (Runnable runnable : jobs) {
                            ComputeJob job = GridClosureProcessor.job(runnable);
                            ClusterNode clusterNode = lb.getBalancedNode(job, null);
                            mapper.map(job, clusterNode);
                        }
                        break;
                    }
                }
                return mapper.map();
            }
            return Collections.emptyMap();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private <R> Map<ComputeJob, ClusterNode> outMap(GridClosureCallMode mode, Collection<? extends Callable<R>> jobs, Collection<ClusterNode> nodes, ComputeLoadBalancer lb) throws IgniteException {
        assert (mode != null);
        assert (jobs != null);
        assert (nodes != null);
        assert (lb != null);
        try {
            if (!F.isEmpty(jobs) && !F.isEmpty(nodes)) {
                JobMapper mapper = new JobMapper(jobs.size());
                switch (mode) {
                    case BROADCAST: {
                        for (ClusterNode n : nodes) {
                            for (Callable<R> c : jobs) {
                                mapper.map(GridClosureProcessor.job(c), n);
                            }
                        }
                        break;
                    }
                    case BALANCE: {
                        for (Callable<R> c : jobs) {
                            ComputeJob job = GridClosureProcessor.job(c);
                            ClusterNode n = lb.getBalancedNode(job, null);
                            mapper.map(job, n);
                        }
                        break;
                    }
                }
                return mapper.map();
            }
            return Collections.emptyMap();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R1, R2> ComputeTaskInternalFuture<R2> forkjoinAsync(GridClosureCallMode mode, Collection<? extends Callable<R1>> jobs, IgniteReducer<R1, R2> rdc, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        assert (mode != null);
        assert (rdc != null);
        assert (!F.isEmpty(jobs));
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T3.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T3(mode, jobs, rdc), null, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public <R> ComputeTaskInternalFuture<Collection<R>> callAsync(GridClosureCallMode mode, @Nullable Collection<? extends Callable<R>> jobs, @Nullable Collection<ClusterNode> nodes) {
        return this.callAsync(mode, jobs, nodes, null);
    }

    public <R> ComputeTaskInternalFuture<Collection<R>> callAsync(GridClosureCallMode mode, @Nullable Collection<? extends Callable<R>> jobs, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        return this.callAsync(mode, jobs, nodes, false, execName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> ComputeTaskInternalFuture<Collection<R>> callAsync(GridClosureCallMode mode, Collection<? extends Callable<R>> jobs, @Nullable Collection<ClusterNode> nodes, boolean sys, @Nullable String execName) {
        assert (mode != null);
        assert (!F.isEmpty(jobs));
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T6.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.task().execute(new T6(mode, jobs), null, sys, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public <R> ComputeTaskInternalFuture<R> callAsync(GridClosureCallMode mode, @Nullable Callable<R> job, @Nullable Collection<ClusterNode> nodes) {
        return this.callAsync(mode, job, nodes, null);
    }

    public <R> ComputeTaskInternalFuture<R> callAsync(GridClosureCallMode mode, @Nullable Callable<R> job, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        return this.callAsync(mode, job, nodes, false, execName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> ComputeTaskInternalFuture<R> affinityCall(@NotNull Collection<String> cacheNames, int partId, Callable<R> job, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) throws IgniteCheckedException {
        assert (partId >= 0) : partId;
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T5.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            String cacheName = F.first(cacheNames);
            AffinityTopologyVersion mapTopVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            ClusterNode node = this.ctx.affinity().mapPartitionToNode(cacheName, partId, mapTopVer);
            if (node == null) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T5.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T5(node, job, cacheNames, partId, mapTopVer), null, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeTaskInternalFuture<?> affinityRun(@NotNull Collection<String> cacheNames, int partId, Runnable job, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) throws IgniteCheckedException {
        assert (partId >= 0) : partId;
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T4.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            String cacheName = F.first(cacheNames);
            AffinityTopologyVersion mapTopVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            ClusterNode node = this.ctx.affinity().mapPartitionToNode(cacheName, partId, mapTopVer);
            if (node == null) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T4.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Void> computeTaskInternalFuture = this.ctx.task().execute(new T4(node, job, cacheNames, partId, mapTopVer), null, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> IgniteInternalFuture<R> callAsyncNoFailover(GridClosureCallMode mode, @Nullable Callable<R> job, @Nullable Collection<ClusterNode> nodes, boolean sys, long timeout, boolean skipAuth) {
        assert (mode != null);
        assert (timeout >= 0L) : timeout;
        this.busyLock.readLock();
        try {
            if (job == null) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                return gridFinishedFuture;
            }
            if (F.isEmpty(nodes)) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(U.emptyTopologyException());
                return gridFinishedFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            if (skipAuth) {
                this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SKIP_AUTH, true);
            }
            if (timeout > 0L) {
                this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TIMEOUT, timeout);
            }
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T7(mode, job), null, sys);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> IgniteInternalFuture<Collection<R>> callAsyncNoFailover(GridClosureCallMode mode, @Nullable Collection<? extends Callable<R>> jobs, @Nullable Collection<ClusterNode> nodes, boolean sys, long timeout) {
        assert (mode != null);
        assert (timeout >= 0L) : timeout;
        this.busyLock.readLock();
        try {
            if (F.isEmpty(jobs)) {
                GridFinishedFuture<Collection<R>> gridFinishedFuture = new GridFinishedFuture<Collection<R>>();
                return gridFinishedFuture;
            }
            if (F.isEmpty(nodes)) {
                GridFinishedFuture<Collection<R>> gridFinishedFuture = new GridFinishedFuture<Collection<R>>(U.emptyTopologyException());
                return gridFinishedFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            if (timeout > 0L) {
                this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TIMEOUT, timeout);
            }
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.task().execute(new T6(mode, jobs), null, sys);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> ComputeTaskInternalFuture<R> callAsync(GridClosureCallMode mode, Callable<R> job, @Nullable Collection<ClusterNode> nodes, boolean sys, @Nullable String execName) {
        assert (mode != null);
        assert (job != null);
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T7.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T7(mode, job), null, sys, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> callAsync(IgniteClosure<T, R> job, @Nullable T arg, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T8.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T8(job, arg), null, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> IgniteInternalFuture<Collection<R>> broadcast(IgniteClosure<T, R> job, @Nullable T arg, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                GridFinishedFuture<Collection<R>> gridFinishedFuture = new GridFinishedFuture<Collection<R>>(U.emptyTopologyException());
                return gridFinishedFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.task().execute(new T11(job), arg, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<Collection<R>> callAsync(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T9.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.task().execute(new T9(job, args), null, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R1, R2> ComputeTaskInternalFuture<R2> callAsync(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc, @Nullable Collection<ClusterNode> nodes, @Nullable String execName) {
        this.busyLock.readLock();
        try {
            if (F.isEmpty(nodes)) {
                ComputeTaskInternalFuture computeTaskInternalFuture = ComputeTaskInternalFuture.finishedFuture(this.ctx, T10.class, U.emptyTopologyException());
                return computeTaskInternalFuture;
            }
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(new T10(job, args, rdc), null, false, execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public void runLocalWithThreadPolicy(IgniteThread thread, Runnable c) {
        assert (thread.stripe() >= 0 || thread.policy() != -1) : thread;
        if (thread.stripe() >= 0) {
            this.ctx.getStripedExecutorService().execute(thread.stripe(), c);
        } else {
            try {
                this.ctx.pools().poolForPolicy(thread.policy()).execute(c);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to get pool for policy: " + thread.policy(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> runLocal(final @Nullable Runnable c, byte plc) throws IgniteCheckedException {
        if (c == null) {
            return new GridFinishedFuture();
        }
        this.busyLock.readLock();
        try {
            if (!(c instanceof GridPlainRunnable)) {
                this.ctx.resource().inject(this.ctx.deploy().getDeployment(c.getClass().getName()), c.getClass(), (Object)c);
            }
            final ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            final GridWorkerFuture fut = new GridWorkerFuture();
            GridWorker w = new GridWorker(this.ctx.igniteInstanceName(), "closure-proc-worker", this.log){

                @Override
                protected void body() {
                    block5: {
                        try {
                            if (ldr != null) {
                                U.wrapThreadLoader(ldr, c);
                            } else {
                                c.run();
                            }
                            fut.onDone();
                        }
                        catch (Throwable e) {
                            if (e instanceof Error) {
                                U.error(this.log, "Closure execution failed with error.", e);
                            }
                            fut.onDone(U.cast(e));
                            if (!(e instanceof Error)) break block5;
                            throw e;
                        }
                    }
                }
            };
            fut.setWorker(w);
            try {
                this.pools.poolForPolicy(plc).execute(w);
            }
            catch (RejectedExecutionException e) {
                U.error(this.log, "Failed to execute worker due to execution rejection (increase upper bound on executor service) [policy=" + plc + ']', e);
                w.run();
            }
            GridWorkerFuture gridWorkerFuture = fut;
            return gridWorkerFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public IgniteInternalFuture<?> runLocalSafe(Runnable c) {
        return this.runLocalSafe(c, true);
    }

    public IgniteInternalFuture<?> runLocalSafe(Runnable c, boolean sys) {
        return this.runLocalSafe(c, sys ? (byte)2 : 0);
    }

    public IgniteInternalFuture<?> runLocalSafe(Runnable c, byte plc) {
        try {
            return this.runLocal(c, plc);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                U.error(this.log, "Closure execution failed with error.", e);
                throw (Error)e;
            }
            if (e.getCause() instanceof RejectedExecutionException) {
                U.warn(this.log, "Closure execution has been rejected (will execute in the same thread) [plc=" + plc + ", closure=" + c + ']');
                try {
                    c.run();
                    return new GridFinishedFuture();
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        U.error(this.log, "Closure execution failed with error.", t);
                        throw t;
                    }
                    return new GridFinishedFuture(U.cast(t));
                }
            }
            return new GridFinishedFuture(U.cast(e));
        }
    }

    private <R> IgniteInternalFuture<R> callLocal(@Nullable Callable<R> c, boolean sys) throws IgniteCheckedException {
        return this.callLocal(c, sys ? (byte)2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> IgniteInternalFuture<R> callLocal(final @Nullable Callable<R> c, byte plc) throws IgniteCheckedException {
        if (c == null) {
            return new GridFinishedFuture();
        }
        this.busyLock.readLock();
        try {
            if (!(c instanceof GridPlainCallable)) {
                this.ctx.resource().inject(this.ctx.deploy().getDeployment(c.getClass().getName()), c.getClass(), c);
            }
            final ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            final GridWorkerFuture fut = new GridWorkerFuture();
            final SecurityContext secCtx = this.ctx.security().securityContext();
            GridWorker w = new GridWorker(this.ctx.igniteInstanceName(), "closure-proc-worker", this.log){

                @Override
                protected void body() {
                    block17: {
                        try (OperationSecurityContext s = GridClosureProcessor.this.ctx.security().withContext(secCtx);){
                            if (ldr != null) {
                                fut.onDone(U.wrapThreadLoader(ldr, c));
                            } else {
                                fut.onDone(c.call());
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof Error) {
                                U.error(this.log, "Closure execution failed with error.", e);
                            }
                            fut.onDone(U.cast(e));
                            if (!(e instanceof Error)) break block17;
                            throw (Error)e;
                        }
                    }
                }
            };
            fut.setWorker(w);
            try {
                this.pools.poolForPolicy(plc).execute(w);
            }
            catch (RejectedExecutionException e) {
                U.error(this.log, "Failed to execute worker due to execution rejection (increase upper bound on executor service) [policy=" + plc + ']', e);
                w.run();
            }
            GridWorkerFuture gridWorkerFuture = fut;
            return gridWorkerFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    public <R> IgniteInternalFuture<R> callLocalSafe(Callable<R> c) {
        return this.callLocalSafe(c, true);
    }

    public <R> IgniteInternalFuture<R> callLocalSafe(Callable<R> c, boolean sys) {
        return this.callLocalSafe(c, sys ? (byte)2 : 0);
    }

    public <R> IgniteInternalFuture<R> callLocalSafe(Callable<R> c, byte plc) {
        try {
            return this.callLocal(c, plc);
        }
        catch (IgniteCheckedException e) {
            if (e.getCause() instanceof RejectedExecutionException) {
                U.warn(this.log, "Closure execution has been rejected (will execute in the same thread) [plc=" + plc + ", closure=" + c + ']');
                try {
                    return new GridFinishedFuture<R>(c.call());
                }
                catch (Exception e2) {
                    return new GridFinishedFuture(U.cast(e2));
                }
            }
            return new GridFinishedFuture(U.cast(e));
        }
    }

    private static <T, R> ComputeJob job(IgniteClosure<T, R> job, @Nullable T arg) {
        A.notNull(job, "job");
        return job instanceof ComputeJobMasterLeaveAware ? new C1MLA(job, arg) : new C1<T, R>(job, arg);
    }

    private static <R> ComputeJob job(Callable<R> c) {
        A.notNull(c, "job");
        return c instanceof ComputeJobMasterLeaveAware ? new C2MLA(c) : new C2(c);
    }

    private static ComputeJob job(Runnable r) {
        A.notNull(r, "job");
        return r instanceof ComputeJobMasterLeaveAware ? new C4MLA(r) : new C4(r);
    }

    private static <R> Collection<R> jobResults(List<ComputeJobResult> res) {
        if (res == null) {
            return Collections.emptyList();
        }
        ArrayList res0 = new ArrayList(res.size());
        for (int i = 0; i < res.size(); ++i) {
            res0.add(res.get(i).getData());
        }
        return res0;
    }

    public static class C4MLA
    extends C4
    implements ComputeJobMasterLeaveAware {
        private static final long serialVersionUID = 0L;

        public C4MLA() {
        }

        private C4MLA(Runnable r) {
            super(r);
        }

        @Override
        public void onMasterNodeLeft(ComputeTaskSession ses) {
            ((ComputeJobMasterLeaveAware)((Object)this.r)).onMasterNodeLeft(ses);
        }

        @Override
        public String toString() {
            return S.toString(C4MLA.class, this, super.toString());
        }
    }

    public static class C4
    implements ComputeJob,
    Binarylizable,
    GridNoImplicitInjection,
    GridInternalWrapper<Runnable> {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        protected Runnable r;

        public C4() {
        }

        private C4(Runnable r) {
            this.r = r;
        }

        @Override
        @Nullable
        public Object execute() {
            this.r.run();
            return null;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.rawWriter().writeObject(this.r);
        }

        @Override
        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.r = (Runnable)reader.rawReader().readObject();
        }

        @Override
        public Runnable userObject() {
            return this.r;
        }

        public String toString() {
            return S.toString(C4.class, this);
        }
    }

    public static class C2MLA<R>
    extends C2<R>
    implements ComputeJobMasterLeaveAware {
        private static final long serialVersionUID = 0L;

        public C2MLA() {
        }

        private C2MLA(Callable<R> c) {
            super(c);
        }

        @Override
        public void onMasterNodeLeft(ComputeTaskSession ses) {
            ((ComputeJobMasterLeaveAware)((Object)this.c)).onMasterNodeLeft(ses);
        }

        @Override
        public String toString() {
            return S.toString(C2MLA.class, this, super.toString());
        }
    }

    public static class C2<R>
    implements ComputeJob,
    Binarylizable,
    GridNoImplicitInjection,
    GridInternalWrapper<Callable> {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        protected Callable<R> c;

        public C2() {
        }

        private C2(Callable<R> c) {
            this.c = c;
        }

        @Override
        public Object execute() {
            try {
                return this.c.call();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void cancel() {
        }

        @Override
        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.rawWriter().writeObject(this.c);
        }

        @Override
        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.c = (Callable)reader.rawReader().readObject();
        }

        @Override
        public Callable userObject() {
            return this.c;
        }

        public String toString() {
            return S.toString(C2.class, this);
        }
    }

    public static class C1MLA<T, R>
    extends C1<T, R>
    implements ComputeJobMasterLeaveAware {
        private static final long serialVersionUID = 0L;

        public C1MLA() {
        }

        private C1MLA(IgniteClosure<T, R> job, T arg) {
            super(job, arg);
        }

        @Override
        public void onMasterNodeLeft(ComputeTaskSession ses) {
            ((ComputeJobMasterLeaveAware)((Object)this.job)).onMasterNodeLeft(ses);
        }

        @Override
        public String toString() {
            return S.toString(C1MLA.class, this, super.toString());
        }
    }

    public static class C1<T, R>
    implements ComputeJob,
    Binarylizable,
    GridNoImplicitInjection,
    GridInternalWrapper<IgniteClosure> {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        protected IgniteClosure<T, R> job;
        @GridToStringInclude(sensitive=true)
        protected T arg;

        public C1() {
        }

        C1(IgniteClosure<T, R> job, T arg) {
            this.job = job;
            this.arg = arg;
        }

        @Override
        @Nullable
        public Object execute() {
            return this.job.apply(this.arg);
        }

        @Override
        public void cancel() {
        }

        @Override
        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            BinaryRawWriter rawWriter = writer.rawWriter();
            rawWriter.writeObject(this.job);
            rawWriter.writeObject(this.arg);
        }

        @Override
        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            BinaryRawReader rawReader = reader.rawReader();
            this.job = (IgniteClosure)rawReader.readObject();
            this.arg = rawReader.readObject();
        }

        @Override
        public IgniteClosure userObject() {
            return this.job;
        }

        public String toString() {
            return S.toString(C1.class, this);
        }
    }

    private class T11<T, R>
    extends GridPeerDeployAwareTaskAdapter<T, Collection<R>>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private final IgniteClosure<T, R> job;

        private T11(IgniteClosure<T, R> job) {
            super(U.peerDeployAware(job));
            this.job = job;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable T arg) {
            if (F.isEmpty(subgrid)) {
                return Collections.emptyMap();
            }
            try {
                JobMapper mapper = new JobMapper(subgrid.size());
                for (ClusterNode n : subgrid) {
                    mapper.map(GridClosureProcessor.job(this.job, arg), n);
                }
                return mapper.map();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public Collection<R> reduce(List<ComputeJobResult> res) {
            return GridClosureProcessor.jobResults(res);
        }
    }

    private class T10<T, R1, R2>
    extends GridPeerDeployAwareTaskAdapter<Void, R2>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private IgniteClosure<T, R1> job;
        private Collection<? extends T> args;
        private IgniteReducer<R1, R2> rdc;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;

        private T10(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc) {
            super(U.peerDeployAware(job));
            this.job = job;
            this.args = args;
            this.rdc = rdc;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            try {
                JobMapper mapper = new JobMapper(this.args.size());
                for (T jobArg : this.args) {
                    ComputeJob job = GridClosureProcessor.job(this.job, jobArg);
                    ClusterNode node = this.lb.getBalancedNode(job, null);
                    mapper.map(job, node);
                }
                return mapper.map();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            ComputeJobResultPolicy resPlc = super.result(res, rcvd);
            if (res.getException() == null && resPlc != ComputeJobResultPolicy.FAILOVER && !this.rdc.collect(res.getData())) {
                resPlc = ComputeJobResultPolicy.REDUCE;
            }
            return resPlc;
        }

        @Override
        public R2 reduce(List<ComputeJobResult> res) {
            return this.rdc.reduce();
        }
    }

    private class T9<T, R>
    extends GridPeerDeployAwareTaskAdapter<Void, Collection<R>>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private IgniteClosure<T, R> job;
        private Collection<? extends T> args;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;

        private T9(IgniteClosure<T, R> job, Collection<? extends T> args) {
            super(U.peerDeployAware(job));
            this.job = job;
            this.args = args;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            try {
                JobMapper mapper = new JobMapper(this.args.size());
                for (T jobArg : this.args) {
                    ComputeJob job = GridClosureProcessor.job(this.job, jobArg);
                    ClusterNode node = this.lb.getBalancedNode(job, null);
                    mapper.map(job, node);
                }
                return mapper.map();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public Collection<R> reduce(List<ComputeJobResult> res) throws IgniteException {
            return GridClosureProcessor.jobResults(res);
        }
    }

    private static class T8<T, R>
    extends GridPeerDeployAwareTaskAdapter<Void, R>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private IgniteClosure<T, R> job;
        private T arg;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;

        private T8(IgniteClosure<T, R> job, @Nullable T arg) {
            super(U.peerDeployAware(job));
            this.job = job;
            this.arg = arg;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            ComputeJob job = GridClosureProcessor.job(this.job, this.arg);
            ClusterNode node = this.lb.getBalancedNode(job, null);
            return Collections.singletonMap(job, node);
        }

        @Override
        public R reduce(List<ComputeJobResult> res) throws IgniteException {
            for (ComputeJobResult r : res) {
                if (r.getException() != null) continue;
                return (R)r.getData();
            }
            throw new IgniteException("Failed to find successful job result: " + res);
        }
    }

    private class T7<R>
    extends GridPeerDeployAwareTaskAdapter<Void, R>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private IgniteBiTuple<GridClosureCallMode, Callable<R>> t;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;

        private T7(GridClosureCallMode mode, Callable<R> job) {
            super(U.peerDeployAware(job));
            this.t = F.t(mode, job);
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return GridClosureProcessor.this.outMap(this.t.get1(), F.asList(this.t.get2()), subgrid, this.lb);
        }

        @Override
        public R reduce(List<ComputeJobResult> res) {
            for (ComputeJobResult r : res) {
                if (r.getException() != null) continue;
                return (R)r.getData();
            }
            throw new IgniteException("Failed to find successful job result: " + res);
        }
    }

    private class T6<R>
    extends GridPeerDeployAwareTaskAdapter<Void, Collection<R>>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        private final GridClosureCallMode mode;
        private final Collection<? extends Callable<R>> jobs;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;

        private T6(GridClosureCallMode mode, Collection<? extends Callable<R>> jobs) {
            super(U.peerDeployAware0(jobs));
            this.mode = mode;
            this.jobs = jobs;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return GridClosureProcessor.this.outMap(this.mode, this.jobs, subgrid, this.lb);
        }

        @Override
        public Collection<R> reduce(List<ComputeJobResult> res) {
            return GridClosureProcessor.jobResults(res);
        }
    }

    private static class T5<R>
    extends GridPeerDeployAwareTaskAdapter<Void, R>
    implements GridNoImplicitInjection,
    AffinityTask {
        private static final long serialVersionUID = 0L;
        private ClusterNode node;
        private Callable<R> job;
        private int partId;
        private AffinityTopologyVersion topVer;
        private Collection<String> affCacheNames;

        private T5(ClusterNode node, Callable<R> job, Collection<String> affCacheNames, int partId, AffinityTopologyVersion topVer) {
            super(U.peerDeployAware0(job));
            this.node = node;
            this.job = job;
            this.affCacheNames = affCacheNames;
            this.partId = partId;
            this.topVer = topVer;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return Collections.singletonMap(GridClosureProcessor.job(this.job), this.node);
        }

        @Override
        public R reduce(List<ComputeJobResult> res) {
            for (ComputeJobResult r : res) {
                if (r.getException() != null) continue;
                return (R)r.getData();
            }
            throw new IgniteException("Failed to find successful job result: " + res);
        }

        @Override
        public int partition() {
            return this.partId;
        }

        @Override
        @Nullable
        public Collection<String> affinityCacheNames() {
            return this.affCacheNames;
        }

        @Override
        @Nullable
        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }
    }

    private static class T4
    extends TaskNoReduceAdapter<Void>
    implements GridNoImplicitInjection,
    AffinityTask {
        private static final long serialVersionUID = 0L;
        private ClusterNode node;
        private Runnable job;
        private int partId;
        private AffinityTopologyVersion topVer;
        private Collection<String> affCacheNames;

        private T4(ClusterNode node, Runnable job, Collection<String> affCacheNames, int partId, AffinityTopologyVersion topVer) {
            super(U.peerDeployAware0((Object)job));
            assert (partId >= 0);
            this.node = node;
            this.job = job;
            this.affCacheNames = affCacheNames;
            this.partId = partId;
            this.topVer = topVer;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return Collections.singletonMap(GridClosureProcessor.job(this.job), this.node);
        }

        @Override
        public int partition() {
            return this.partId;
        }

        @Override
        @Nullable
        public Collection<String> affinityCacheNames() {
            return this.affCacheNames;
        }

        @Override
        @Nullable
        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }
    }

    private class T3<R1, R2>
    extends GridPeerDeployAwareTaskAdapter<Void, R2>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;
        private GridTuple3<GridClosureCallMode, Collection<? extends Callable<R1>>, IgniteReducer<R1, R2>> t;

        private T3(GridClosureCallMode mode, Collection<? extends Callable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
            super(U.peerDeployAware0(jobs));
            this.t = F.t(mode, jobs, rdc);
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return GridClosureProcessor.this.outMap(this.t.get1(), this.t.get2(), subgrid, this.lb);
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            ComputeJobResultPolicy resPlc = super.result(res, rcvd);
            if (res.getException() == null && resPlc != ComputeJobResultPolicy.FAILOVER && !this.t.get3().collect(res.getData())) {
                resPlc = ComputeJobResultPolicy.REDUCE;
            }
            return resPlc;
        }

        @Override
        public R2 reduce(List<ComputeJobResult> res) {
            return this.t.get3().reduce();
        }
    }

    private class T2
    extends TaskNoReduceAdapter<Void>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;
        private IgniteBiTuple<GridClosureCallMode, Runnable> t;

        private T2(GridClosureCallMode mode, Runnable job) {
            super(U.peerDeployAware(job));
            this.t = F.t(mode, job);
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return GridClosureProcessor.this.absMap(this.t.get1(), F.asList(this.t.get2()), subgrid, this.lb);
        }
    }

    private class T1
    extends TaskNoReduceAdapter<Void>
    implements GridNoImplicitInjection {
        private static final long serialVersionUID = 0L;
        @LoadBalancerResource
        private ComputeLoadBalancer lb;
        private IgniteBiTuple<GridClosureCallMode, Collection<? extends Runnable>> t;

        private T1(GridClosureCallMode mode, Collection<? extends Runnable> jobs) {
            super(U.peerDeployAware0(jobs));
            this.t = F.t(mode, jobs);
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) {
            return GridClosureProcessor.this.absMap(this.t.get1(), this.t.get2(), subgrid, this.lb);
        }
    }

    private static abstract class TaskNoReduceAdapter<T>
    extends GridPeerDeployAwareTaskAdapter<T, Void> {
        private static final long serialVersionUID = 0L;

        protected TaskNoReduceAdapter(@Nullable GridPeerDeployAware pda) {
            super(pda);
        }

        @Override
        @Nullable
        public Void reduce(List<ComputeJobResult> results) {
            return null;
        }
    }

    private class JobMapper {
        private final Map<ComputeJob, ClusterNode> map;
        private boolean hadLocNode;

        private JobMapper(int expJobCnt) {
            this.map = IgniteUtils.newHashMap(expJobCnt);
        }

        public void map(@NotNull ComputeJob job, @NotNull ClusterNode node) throws IgniteCheckedException {
            if (GridClosureProcessor.this.ctx.localNodeId().equals(node.id())) {
                if (this.hadLocNode) {
                    Marshaller marsh = GridClosureProcessor.this.ctx.config().getMarshaller();
                    job = (ComputeJob)U.unmarshal(marsh, U.marshal(marsh, (Object)job), U.resolveClassLoader(GridClosureProcessor.this.ctx.config()));
                } else {
                    this.hadLocNode = true;
                }
            }
            this.map.put(job, node);
        }

        public Map<ComputeJob, ClusterNode> map() {
            return this.map;
        }
    }
}

