/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum GridRestCommand {
    CACHE_GET("get"),
    CACHE_CONTAINS_KEY("conkey"),
    CACHE_CONTAINS_KEYS("conkeys"),
    CACHE_GET_ALL("getall"),
    CACHE_GET_AND_PUT("getput"),
    CACHE_GET_AND_PUT_IF_ABSENT("getputifabs"),
    CACHE_PUT("put"),
    CACHE_PUT_IF_ABSENT("putifabs"),
    CACHE_ADD("add"),
    CACHE_PUT_ALL("putall"),
    CACHE_REMOVE("rmv"),
    CACHE_REMOVE_VALUE("rmvval"),
    CACHE_GET_AND_REMOVE("getrmv"),
    CACHE_REMOVE_ALL("rmvall"),
    CACHE_CLEAR("clear"),
    CACHE_REPLACE("rep"),
    CACHE_REPLACE_VALUE("repval"),
    CACHE_GET_AND_REPLACE("getrep"),
    CACHE_CAS("cas"),
    CACHE_APPEND("append"),
    CACHE_PREPEND("prepend"),
    CACHE_METRICS("cache"),
    CACHE_SIZE("size"),
    CACHE_UPDATE_TLL("updatettl"),
    CACHE_METADATA("metadata"),
    ATOMIC_INCREMENT("incr"),
    ATOMIC_DECREMENT("decr"),
    TOPOLOGY("top"),
    NODE("node"),
    EXE("exe"),
    RESULT("res"),
    VERSION("version"),
    NAME("name"),
    LOG("log"),
    NOOP("noop"),
    QUIT("quit"),
    GET_OR_CREATE_CACHE("getorcreate"),
    DESTROY_CACHE("destcache"),
    EXECUTE_SQL_QUERY("qryexe"),
    EXECUTE_SQL_FIELDS_QUERY("qryfldexe"),
    EXECUTE_SCAN_QUERY("qryscanexe"),
    FETCH_SQL_QUERY("qryfetch"),
    CLOSE_SQL_QUERY("qrycls"),
    CLUSTER_ACTIVE("active"),
    CLUSTER_INACTIVE("inactive"),
    CLUSTER_ACTIVATE("activate"),
    CLUSTER_DEACTIVATE("deactivate"),
    CLUSTER_CURRENT_STATE("currentstate"),
    CLUSTER_NAME("clustername"),
    CLUSTER_STATE("state"),
    CLUSTER_SET_STATE("setstate"),
    BASELINE_CURRENT_STATE("baseline"),
    BASELINE_SET("setbaseline"),
    BASELINE_ADD("addbaseline"),
    BASELINE_REMOVE("removebaseline"),
    AUTHENTICATE("authenticate"),
    ADD_USER("adduser"),
    REMOVE_USER("removeuser"),
    UPDATE_USER("updateuser"),
    DATA_REGION_METRICS("dataregion"),
    DATA_STORAGE_METRICS("datastorage"),
    NODE_STATE_BEFORE_START("nodestatebeforestart"),
    WARM_UP("warmup"),
    PROBE("probe");

    private static final GridRestCommand[] VALS;
    private static final Map<String, GridRestCommand> cmds;
    private final String key;

    private GridRestCommand(String key) {
        this.key = key;
    }

    @Nullable
    public static GridRestCommand fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    @Nullable
    public static GridRestCommand fromKey(String key) {
        return cmds.get(key);
    }

    public String key() {
        return this.key;
    }

    static {
        VALS = GridRestCommand.values();
        cmds = new HashMap<String, GridRestCommand>();
        for (GridRestCommand cmd : GridRestCommand.values()) {
            cmds.put(cmd.key(), cmd);
        }
    }
}

