/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;

public abstract class TcpDiscoveryIpFinderAdapter
implements TcpDiscoveryIpFinder {
    private boolean shared;
    @GridToStringExclude
    private volatile IgniteSpiContext spiCtx;
    @Deprecated
    @IgniteInstanceResource
    @GridToStringExclude
    protected Ignite ignite;

    @Override
    public void onSpiContextInitialized(IgniteSpiContext spiCtx) throws IgniteSpiException {
        this.spiCtx = spiCtx;
    }

    @Override
    public void onSpiContextDestroyed() {
        this.spiCtx = null;
    }

    @Override
    public void initializeLocalAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        this.registerAddresses(addrs);
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryIpFinderAdapter setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoveryIpFinderAdapter.class, this);
    }

    @Override
    public void close() {
    }

    @Deprecated
    protected boolean discoveryClientMode() {
        boolean clientMode;
        Ignite ignite0 = this.ignite;
        if (ignite0 != null) {
            DiscoverySpi discoSpi = ignite0.configuration().getDiscoverySpi();
            if (!(discoSpi instanceof TcpDiscoverySpi)) {
                throw new IgniteSpiException("TcpDiscoveryIpFinder should be used with TcpDiscoverySpi: " + discoSpi);
            }
            clientMode = ignite0.configuration().isClientMode() != false && !((TcpDiscoverySpi)discoSpi).isForceServerMode();
        } else {
            clientMode = false;
        }
        return clientMode;
    }

    protected IgniteSpiContext spiContext() {
        return this.spiCtx;
    }
}

