/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.arena;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.binaryallocator.BinaryAllocator;
import org.apache.iotdb.commons.binaryallocator.config.AllocatorConfig;
import org.apache.iotdb.commons.binaryallocator.ema.AdaptiveWeightedAverage;
import org.apache.iotdb.commons.binaryallocator.utils.SizeClasses;

public class Arena {
    private static final int EVICT_SAMPLE_COUNT = 100;
    private final BinaryAllocator binaryAllocator;
    private final SizeClasses sizeClasses;
    private final int arenaID;
    private final AtomicInteger numRegisteredThread;
    private final SlabRegion[] regions;
    private int sampleCount;

    public Arena(BinaryAllocator allocator, SizeClasses sizeClasses, int id, AllocatorConfig allocatorConfig) {
        this.binaryAllocator = allocator;
        this.sizeClasses = sizeClasses;
        this.arenaID = id;
        this.numRegisteredThread = new AtomicInteger(0);
        this.regions = new SlabRegion[sizeClasses.getSizeClassNum()];
        for (int i = 0; i < this.regions.length; ++i) {
            this.regions[i] = new SlabRegion(sizeClasses.sizeIdx2size(i), allocatorConfig);
        }
        this.sampleCount = 0;
    }

    public int getArenaID() {
        return this.arenaID;
    }

    public byte[] allocate(int reqCapacity) {
        int sizeIdx = this.sizeClasses.size2SizeIdx(reqCapacity);
        return this.regions[sizeIdx].allocate();
    }

    public void deallocate(byte[] bytes) {
        int sizeIdx = this.sizeClasses.size2SizeIdx(bytes.length);
        this.regions[sizeIdx].deallocate(bytes);
    }

    public long evict(double ratio) {
        long evictedSize = 0L;
        for (SlabRegion region : this.regions) {
            evictedSize += region.evict(ratio);
        }
        return evictedSize;
    }

    public void close() {
        this.sampleCount = 0;
        for (SlabRegion region : this.regions) {
            region.close();
        }
    }

    public long getTotalUsedMemory() {
        long totalUsedMemory = 0L;
        for (SlabRegion region : this.regions) {
            totalUsedMemory += region.getTotalUsedMemory();
        }
        return totalUsedMemory;
    }

    public long getActiveMemory() {
        long totalActiveMemory = 0L;
        for (SlabRegion region : this.regions) {
            totalActiveMemory += region.getActiveUsedMemory();
        }
        return totalActiveMemory;
    }

    public int getNumRegisteredThread() {
        return this.numRegisteredThread.get();
    }

    public void incRegisteredThread() {
        this.numRegisteredThread.incrementAndGet();
    }

    public void decRegisteredThread() {
        this.numRegisteredThread.decrementAndGet();
    }

    public long runSampleEviction() {
        long allocateFromSlabDelta = 0L;
        long allocateFromJVMDelta = 0L;
        for (SlabRegion region : this.regions) {
            allocateFromSlabDelta += (long)region.byteArraySize * (long)(region.allocationsFromAllocator.get() - region.prevAllocations);
            region.prevAllocations = region.allocationsFromAllocator.get();
            allocateFromJVMDelta += (long)region.byteArraySize * (long)(region.allocationsFromJVM.get() - region.prevAllocationsFromJVM);
            region.prevAllocationsFromJVM = region.allocationsFromJVM.get();
        }
        this.binaryAllocator.getMetrics().updateAllocationCounter(allocateFromSlabDelta, allocateFromJVMDelta);
        for (SlabRegion region : this.regions) {
            region.updateSample();
        }
        ++this.sampleCount;
        long evictedSize = 0L;
        if (this.sampleCount == 100) {
            for (SlabRegion region : this.regions) {
                evictedSize += region.resize();
            }
            this.sampleCount = 0;
        }
        return evictedSize;
    }

    private static class SlabRegion {
        private final int byteArraySize;
        private final ConcurrentLinkedQueue<byte[]> queue;
        private final AtomicInteger allocationsFromAllocator;
        private final AtomicInteger allocationsFromJVM;
        private final AtomicInteger deAllocationsToAllocator;
        private final AtomicInteger evictions;
        public int prevAllocations;
        public int prevAllocationsFromJVM;
        AdaptiveWeightedAverage average;

        SlabRegion(int byteArraySize, AllocatorConfig allocatorConfig) {
            this.byteArraySize = byteArraySize;
            this.average = new AdaptiveWeightedAverage(allocatorConfig.arenaPredictionWeight);
            this.queue = new ConcurrentLinkedQueue();
            this.allocationsFromAllocator = new AtomicInteger(0);
            this.allocationsFromJVM = new AtomicInteger(0);
            this.deAllocationsToAllocator = new AtomicInteger(0);
            this.evictions = new AtomicInteger(0);
            this.prevAllocations = 0;
            this.prevAllocationsFromJVM = 0;
        }

        public final byte[] allocate() {
            byte[] bytes = this.queue.poll();
            if (bytes == null) {
                this.allocationsFromJVM.incrementAndGet();
                return new byte[this.byteArraySize];
            }
            this.allocationsFromAllocator.incrementAndGet();
            return bytes;
        }

        public void deallocate(byte[] bytes) {
            this.deAllocationsToAllocator.incrementAndGet();
            this.queue.add(bytes);
        }

        private void updateSample() {
            this.average.sample(this.getActiveSize());
        }

        private long resize() {
            this.average.update();
            int needRemain = (int)Math.ceil(this.average.average()) - this.getActiveSize();
            return this.evict(this.getQueueSize() - needRemain);
        }

        private long evict(double ratio) {
            return this.evict((int)((double)this.getQueueSize() * ratio));
        }

        private long evict(int num) {
            long evicted = 0L;
            while (num > 0 && !this.queue.isEmpty()) {
                this.queue.poll();
                this.evictions.incrementAndGet();
                --num;
                evicted += (long)this.byteArraySize;
            }
            return evicted;
        }

        private long getTotalUsedMemory() {
            return (long)this.byteArraySize * (long)this.getQueueSize();
        }

        private long getActiveUsedMemory() {
            return (long)this.byteArraySize * (long)this.getActiveSize();
        }

        private int getQueueSize() {
            return this.deAllocationsToAllocator.get() - this.allocationsFromAllocator.get() - this.evictions.get();
        }

        private int getActiveSize() {
            return this.allocationsFromAllocator.get() + this.allocationsFromJVM.get() - this.deAllocationsToAllocator.get();
        }

        private void close() {
            this.queue.clear();
            this.allocationsFromAllocator.set(0);
            this.allocationsFromJVM.set(0);
            this.deAllocationsToAllocator.set(0);
            this.evictions.set(0);
            this.prevAllocations = 0;
            this.prevAllocationsFromJVM = 0;
            this.average.clear();
        }
    }
}

