/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.meta;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMetaInAgent;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMetaInCoordinator;
import org.apache.tsfile.utils.PublicBAOS;

public class PipeMeta {
    private final PipeStaticMeta staticMeta;
    private final PipeRuntimeMeta runtimeMeta;
    private final PipeTemporaryMeta temporaryMeta;

    public PipeMeta(PipeStaticMeta staticMeta, PipeRuntimeMeta runtimeMeta) {
        this(staticMeta, runtimeMeta, new PipeTemporaryMetaInCoordinator());
    }

    public PipeMeta(PipeStaticMeta staticMeta, PipeRuntimeMeta runtimeMeta, PipeTemporaryMeta temporaryMeta) {
        this.staticMeta = staticMeta;
        this.runtimeMeta = runtimeMeta;
        this.temporaryMeta = temporaryMeta;
    }

    public PipeStaticMeta getStaticMeta() {
        return this.staticMeta;
    }

    public PipeRuntimeMeta getRuntimeMeta() {
        return this.runtimeMeta;
    }

    public PipeTemporaryMeta getTemporaryMeta() {
        return this.temporaryMeta;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.staticMeta.serialize(outputStream);
        this.runtimeMeta.serialize(outputStream);
    }

    public static PipeMeta deserialize(FileInputStream fileInputStream) throws IOException {
        PipeStaticMeta staticMeta = PipeStaticMeta.deserialize(fileInputStream);
        PipeRuntimeMeta runtimeMeta = PipeRuntimeMeta.deserialize(fileInputStream);
        return new PipeMeta(staticMeta, runtimeMeta);
    }

    public static PipeMeta deserialize4TaskAgent(ByteBuffer byteBuffer) {
        PipeStaticMeta staticMeta = PipeStaticMeta.deserialize(byteBuffer);
        PipeRuntimeMeta runtimeMeta = PipeRuntimeMeta.deserialize(byteBuffer);
        return new PipeMeta(staticMeta, runtimeMeta, new PipeTemporaryMetaInAgent(staticMeta.getPipeName(), staticMeta.getCreationTime()));
    }

    public static PipeMeta deserialize4Coordinator(ByteBuffer byteBuffer) {
        PipeStaticMeta staticMeta = PipeStaticMeta.deserialize(byteBuffer);
        PipeRuntimeMeta runtimeMeta = PipeRuntimeMeta.deserialize(byteBuffer);
        return new PipeMeta(staticMeta, runtimeMeta);
    }

    public PipeMeta deepCopy4TaskAgent() throws IOException {
        return PipeMeta.deserialize4TaskAgent(this.serialize());
    }

    public String coreReportMessage() {
        return "PipeName=" + this.staticMeta.getPipeName() + ", CreationTime=" + this.staticMeta.getCreationTime() + ", ProgressIndex={" + this.runtimeMeta.getConsensusGroupId2TaskMetaMap().entrySet().stream().map(entry -> "ConsensusGroupId=" + entry.getKey() + ", ProgressIndex=" + ((PipeTaskMeta)entry.getValue()).getProgressIndex()).reduce((s1, s2) -> s1 + "; " + s2).orElse("") + "}, Exceptions={" + this.runtimeMeta.getConsensusGroupId2TaskMetaMap().entrySet().stream().filter(entry -> ((PipeTaskMeta)entry.getValue()).hasExceptionMessages()).map(entry -> "ConsensusGroupId=" + entry.getKey() + ", ExceptionMessage=" + ((PipeTaskMeta)entry.getValue()).getExceptionMessagesString()).reduce((s1, s2) -> s1 + "; " + s2).orElse("") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeMeta pipeMeta = (PipeMeta)o;
        return Objects.equals(this.staticMeta, pipeMeta.staticMeta) && Objects.equals(this.runtimeMeta, pipeMeta.runtimeMeta) && Objects.equals(this.temporaryMeta, pipeMeta.temporaryMeta);
    }

    public int hashCode() {
        return Objects.hash(this.staticMeta, this.runtimeMeta, this.temporaryMeta);
    }

    public String toString() {
        return "PipeMeta{staticMeta=" + this.staticMeta + ", runtimeMeta=" + this.runtimeMeta + ", temporaryMeta=" + this.temporaryMeta + '}';
    }
}

