/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MergeSortMultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.MergeSortMultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.OrderedMultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.OrderedMultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;

public class MemPointIteratorFactory {
    private MemPointIteratorFactory() {
    }

    private static MemPointIterator single(List<TVList> tvLists, int maxNumberOfPointsInPage) {
        return tvLists.get(0).iterator(Ordering.ASC, tvLists.get((int)0).rowCount, null, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator single(List<TVList> tvLists, List<TimeRange> deletionList, int maxNumberOfPointsInPage) {
        return tvLists.get(0).iterator(Ordering.ASC, tvLists.get((int)0).rowCount, null, deletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator single(List<TVList> tvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        return tvLists.get(0).iterator(scanOrder, tvListRowCounts.get(0), globalTimeFilter, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists, int maxNumberOfPointsInPage) {
        return new MergeSortMultiTVListIterator(Ordering.ASC, null, tsDataType, tvLists, null, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, int maxNumberOfPointsInPage) {
        return new MergeSortMultiTVListIterator(Ordering.ASC, null, tsDataType, tvLists, null, deletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        return new MergeSortMultiTVListIterator(scanOrder, globalTimeFilter, tsDataType, tvLists, tvListRowCounts, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists, int maxNumberOfPointsInPage) {
        return new OrderedMultiTVListIterator(Ordering.ASC, null, tsDataType, tvLists, null, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, int maxNumberOfPointsInPage) {
        return new OrderedMultiTVListIterator(Ordering.ASC, null, tsDataType, tvLists, null, deletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        return new OrderedMultiTVListIterator(scanOrder, globalTimeFilter, tsDataType, tvLists, tvListRowCounts, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, int maxNumberOfPointsInPage) {
        return alignedTvLists.get(0).iterator(Ordering.ASC, alignedTvLists.get((int)0).rowCount, null, tsDataTypes, columnIndexList, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<List<TimeRange>> valueColumnsDeletionList, int maxNumberOfPointsInPage) {
        return alignedTvLists.get(0).iterator(Ordering.ASC, alignedTvLists.get((int)0).rowCount, null, tsDataTypes, columnIndexList, valueColumnsDeletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, int maxNumberOfPointsInPage) {
        return alignedTvLists.get(0).iterator(scanOrder, tvListRowCounts.get(0), globalTimeFilter, tsDataTypes, columnIndexList, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, int maxNumberOfPointsInPage) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, Ordering.ASC, null, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<List<TimeRange>> valueColumnsDeletionList, int maxNumberOfPointsInPage) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, Ordering.ASC, null, valueColumnsDeletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, int maxNumberOfPointsInPage) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, int maxNumberOfPointsInPage) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, Ordering.ASC, null, null, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<List<TimeRange>> valueColumnsDeletionList, int maxNumberOfPointsInPage) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, Ordering.ASC, null, valueColumnsDeletionList, null, null, maxNumberOfPointsInPage);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, int maxNumberOfPointsInPage) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists, int maxNumberOfPointsInPage) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists, null)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, int maxNumberOfPointsInPage) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists, deletionList, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists, null)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists, deletionList, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists, deletionList, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists, tvListRowCounts, scanOrder, globalTimeFilter, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists, tvListRowCounts)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists, tvListRowCounts, scanOrder, globalTimeFilter, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists, tvListRowCounts, scanOrder, globalTimeFilter, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, int maxNumberOfPointsInPage) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists, null)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<List<TimeRange>> valueColumnsDeletionList, int maxNumberOfPointsInPage) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, valueColumnsDeletionList, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists, null)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, valueColumnsDeletionList, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, valueColumnsDeletionList, maxNumberOfPointsInPage);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, int maxNumberOfPointsInPage) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists, tvListRowCounts)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
    }

    private static boolean isCompleteOrdered(List<? extends TVList> tvLists, List<Integer> tvListRowCounts) {
        long time = Long.MIN_VALUE;
        for (int i = 0; i < tvLists.size(); ++i) {
            int rowCount;
            TVList list = tvLists.get(i);
            int n = rowCount = tvListRowCounts == null ? list.rowCount() : tvListRowCounts.get(i).intValue();
            if (rowCount == 0) continue;
            if (list.seqRowCount() < rowCount) {
                return false;
            }
            if (i > 0 && list.getTime(0) <= time) {
                return false;
            }
            time = list.getTime(rowCount - 1);
        }
        return true;
    }
}

