/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.AbstractOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder.HashAggregationBuilder;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder.InMemoryHashAggregationBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.RamUsageEstimator;

public class StreamingHashAggregationOperator
extends AbstractOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(StreamingHashAggregationOperator.class);
    private final Operator child;
    private final int[] preGroupedChannels;
    private final int[] preGroupedIndexInResult;
    private final int[] unPreGroupedIndexInResult;
    private final int valueColumnsCount;
    private final int resultColumnsCount;
    private HashAggregationBuilder aggregationBuilder;
    private final MemoryReservationManager memoryReservationManager;
    private long previousRetainedSize = 0L;
    private boolean finished = false;
    private SortKey currentGroup;
    private final Comparator<SortKey> groupKeyComparator;
    private final Deque<TsBlock> outputs = new LinkedList<TsBlock>();
    private long maxUsedMemory;

    public StreamingHashAggregationOperator(OperatorContext operatorContext, Operator child, List<Integer> preGroupedChannels, List<Integer> preGroupedIndexInResult, List<Type> unPreGroupedTypes, List<Integer> unPreGroupedChannels, List<Integer> unPreGroupedIndexInResult, Comparator<SortKey> groupKeyComparator, List<GroupedAggregator> aggregators, AggregationNode.Step step, int expectedGroups, long maxPartialMemory, boolean spillEnabled, long unSpillMemoryLimit) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.preGroupedChannels = Ints.toArray(preGroupedChannels);
        this.preGroupedIndexInResult = Ints.toArray(preGroupedIndexInResult);
        this.unPreGroupedIndexInResult = Ints.toArray(unPreGroupedIndexInResult);
        this.groupKeyComparator = groupKeyComparator;
        this.valueColumnsCount = aggregators.size();
        this.resultColumnsCount = this.preGroupedIndexInResult.length + this.unPreGroupedIndexInResult.length + aggregators.size();
        Preconditions.checkArgument((!spillEnabled ? 1 : 0) != 0, (Object)"spill is not supported");
        this.aggregationBuilder = new InMemoryHashAggregationBuilder(aggregators, step, expectedGroups, unPreGroupedTypes, unPreGroupedChannels, Optional.empty(), operatorContext, maxPartialMemory, UpdateMemory.NOOP);
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
        this.updateOccupiedMemorySize();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished || this.retainedTsBlock != null || !this.outputs.isEmpty();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (!this.outputs.isEmpty()) {
            this.resultTsBlock = this.outputs.removeFirst();
            return this.checkTsBlockSizeAndGetResult();
        }
        if (this.child.hasNextWithTimer()) {
            TsBlock block = this.child.nextWithTimer();
            if (block == null || block.isEmpty()) {
                return null;
            }
            this.processInput(block);
        } else {
            if (this.currentGroup != null) {
                this.evaluateAndFlushGroup(this.currentGroup.tsBlock, this.currentGroup.rowIndex);
                this.currentGroup = null;
            }
            this.finished = true;
            this.closeAggregationBuilder();
        }
        if (this.outputs.isEmpty()) {
            return null;
        }
        this.resultTsBlock = this.outputs.removeFirst();
        return this.checkTsBlockSizeAndGetResult();
    }

    private void processInput(TsBlock page) {
        Objects.requireNonNull(page, "page is null");
        if (this.currentGroup != null) {
            if (this.groupKeyComparator.compare(this.currentGroup, new SortKey(page, 0)) != 0) {
                this.evaluateAndFlushGroup(this.currentGroup.tsBlock, this.currentGroup.rowIndex);
            }
            this.currentGroup = null;
        }
        int startPosition = 0;
        while (true) {
            int nextGroupStart = this.findNextGroupStart(startPosition, page);
            this.addRowsToAggregationBuilder(page, startPosition, nextGroupStart - 1);
            if (nextGroupStart >= page.getPositionCount()) break;
            this.evaluateAndFlushGroup(page, startPosition);
            startPosition = nextGroupStart;
        }
        this.currentGroup = new SortKey(page, page.getPositionCount() - 1);
    }

    private void addRowsToAggregationBuilder(TsBlock page, int startPosition, int endPosition) {
        TsBlock region = page.getRegion(startPosition, endPosition - startPosition + 1);
        this.aggregationBuilder.processBlock(region);
        this.updateOccupiedMemorySize();
    }

    private void resetAggregationBuilder() {
        this.aggregationBuilder.reset();
        this.updateOccupiedMemorySize();
    }

    private void evaluateAndFlushGroup(TsBlock page, int position) {
        int offset = this.preGroupedIndexInResult.length + this.unPreGroupedIndexInResult.length;
        do {
            int i;
            Column[] result = new Column[this.resultColumnsCount];
            TsBlock buildResult = this.aggregationBuilder.buildResult();
            for (i = 0; i < this.preGroupedIndexInResult.length; ++i) {
                Column column = page.getColumn(this.preGroupedChannels[i]).getRegion(position, 1);
                result[this.preGroupedIndexInResult[i]] = new RunLengthEncodedColumn(column, buildResult.getPositionCount());
            }
            for (i = 0; i < this.unPreGroupedIndexInResult.length; ++i) {
                result[this.unPreGroupedIndexInResult[i]] = buildResult.getColumn(i);
            }
            for (i = 0; i < this.valueColumnsCount; ++i) {
                result[offset + i] = buildResult.getColumn(i + this.unPreGroupedIndexInResult.length);
            }
            this.outputs.add(TsBlock.wrapBlocksWithoutCopy((int)buildResult.getPositionCount(), (Column)buildResult.getTimeColumn(), (Column[])result));
        } while (!this.aggregationBuilder.finished());
        this.resetAggregationBuilder();
    }

    private int findNextGroupStart(int startPosition, TsBlock page) {
        int high;
        SortKey currentKey = new SortKey(page, startPosition);
        SortKey compareKey = new SortKey(page, page.getPositionCount() - 1);
        if (this.groupKeyComparator.compare(currentKey, compareKey) == 0) {
            return page.getPositionCount();
        }
        compareKey.rowIndex = startPosition + 1;
        if (this.groupKeyComparator.compare(currentKey, compareKey) != 0) {
            return startPosition + 1;
        }
        int low = startPosition + 1;
        int firstDiff = high = page.getPositionCount() - 1;
        while (low <= high) {
            int mid;
            compareKey.rowIndex = mid = low + (high - low) / 2;
            int cmp = this.groupKeyComparator.compare(currentKey, compareKey);
            if (cmp == 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
            firstDiff = compareKey.rowIndex;
        }
        return firstDiff;
    }

    private void updateOccupiedMemorySize() {
        long delta;
        long memorySize = this.aggregationBuilder.getEstimatedSize();
        this.operatorContext.recordSpecifiedInfo("CurrentUsedMemory", Long.toString(memorySize));
        if (memorySize > this.maxUsedMemory) {
            this.operatorContext.recordSpecifiedInfo("MaxUsedMemory", Long.toString(memorySize));
            this.maxUsedMemory = memorySize;
        }
        if ((delta = memorySize - this.previousRetainedSize) > 0L) {
            this.memoryReservationManager.reserveMemoryCumulatively(delta);
        } else if (delta < 0L) {
            this.memoryReservationManager.releaseMemoryCumulatively(-delta);
        }
        this.previousRetainedSize = memorySize;
    }

    private void closeAggregationBuilder() {
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.close();
            this.aggregationBuilder = null;
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished && this.retainedTsBlock == null && this.outputs.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.child.calculateMaxPeekMemoryWithCounter(), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateMaxReturnSize() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.outputs.stream().mapToLong(TsBlock::getRetainedSizeInBytes).sum();
    }
}

