/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.ExtendedPartialPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.impl.StringValueFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;

public class DeviceFilterUtil {
    private DeviceFilterUtil() {
    }

    public static List<PartialPath> convertToDevicePattern(String[] prefix, int tagColumnNum, List<List<SchemaFilter>> tagDeterminedFilterList, boolean isRestrict) {
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        int length = tagColumnNum + prefix.length;
        for (List<SchemaFilter> tagFilterList : tagDeterminedFilterList) {
            Object[] nodes = new String[length];
            Arrays.fill(nodes, "*");
            System.arraycopy(prefix, 0, nodes, 0, prefix.length);
            ExtendedPartialPath partialPath = new ExtendedPartialPath((String[])nodes, isRestrict);
            for (SchemaFilter schemaFilter : tagFilterList) {
                if (schemaFilter.getSchemaFilterType().equals((Object)SchemaFilterType.TAG)) {
                    int index = ((TagFilter)schemaFilter).getIndex() + prefix.length;
                    SchemaFilter childFilter = ((TagFilter)schemaFilter).getChild();
                    if (childFilter.getSchemaFilterType().equals((Object)SchemaFilterType.PRECISE)) {
                        nodes[index] = ((PreciseFilter)childFilter).getValue();
                        continue;
                    }
                    partialPath.addMatchFunction(index, node -> Boolean.TRUE.equals(childFilter.accept(StringValueFilterVisitor.getInstance(), node)));
                    continue;
                }
                throw new IllegalStateException("Input single filter must be DeviceIdFilter");
            }
            pathList.add(partialPath);
        }
        return pathList;
    }
}

