/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.common.Constants;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.schema.AbstractImportSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class ImportSchemaTree
extends AbstractImportSchema {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static SessionPool sessionPool;

    @Override
    public void init() throws InterruptedException, IoTDBConnectionException, StatementExecutionException {
        sessionPool = new SessionPool.Builder().host(host).port(Integer.parseInt(port)).user(username).password(password).maxSize(threadNum + 1).enableIoTDBRpcCompression(false).enableRedirection(false).enableAutoFetch(false).build();
        sessionPool.setEnableQueryRedirection(false);
        File file = new File(targetPath);
        if (!file.isFile() && !file.isDirectory()) {
            ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
            System.exit(1);
        }
        ImportDataScanTool.setSourceFullPath(targetPath);
        ImportDataScanTool.traverseAndCollectFiles();
    }

    @Override
    protected Runnable getAsyncImportRunnable() {
        return new ImportSchemaTree();
    }

    @Override
    protected void importSchemaFromSqlFile(File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void importSchemaFromCsvFile(File file) {
        try {
            CSVParser csvRecords = ImportSchemaTree.readCsvFile(file.getAbsolutePath());
            List headerNames = csvRecords.getHeaderNames();
            Stream records = csvRecords.stream();
            if (headerNames.isEmpty()) {
                ioTPrinter.println(file.getName() + " : Empty file!");
                return;
            }
            if (!ImportSchemaTree.checkHeader(headerNames)) {
                return;
            }
            String failedFilePath = null;
            failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
            ImportSchemaTree.writeScheme(file.getName(), headerNames, records, failedFilePath);
            this.processSuccessFile();
        }
        catch (IOException | IllegalPathException e) {
            ioTPrinter.println(file.getName() + " : CSV file read exception because: " + e.getMessage());
        }
    }

    private static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('`').setEscape('\\').setIgnoreEmptyLines(true).build().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    private static boolean checkHeader(List<String> headerNames) {
        List strangers;
        if (CollectionUtils.isNotEmpty(headerNames) && new HashSet<String>(headerNames).size() == Constants.HEAD_COLUMNS.size() && CollectionUtils.isNotEmpty(strangers = headerNames.stream().filter(t -> !Constants.HEAD_COLUMNS.contains(t)).collect(Collectors.toList()))) {
            ioTPrinter.println("The header of the CSV file to be imported is illegal. The correct format is \"Timeseries, Alibaba, DataType, Encoding, Compression\"!");
            return false;
        }
        return true;
    }

    private static void writeScheme(String fileName, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        ArrayList<String> pathsWithAlias = new ArrayList<String>();
        ArrayList<TSDataType> dataTypesWithAlias = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodingsWithAlias = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressorsWithAlias = new ArrayList<CompressionType>();
        ArrayList<String> measurementAlias = new ArrayList<String>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            boolean failed = false;
            if (!aligned.booleanValue()) {
                if (Boolean.FALSE.equals(hasStarted.get())) {
                    hasStarted.set(true);
                } else if (pointSize.get() >= batchPointSize) {
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)paths)) {
                            ImportSchemaTree.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, null, null, null, null, 3);
                        }
                    }
                    catch (Exception e) {
                        paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
                    }
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)pathsWithAlias)) {
                            ImportSchemaTree.writeAndEmptyDataSet(pathsWithAlias, dataTypesWithAlias, encodingsWithAlias, compressorsWithAlias, null, null, null, measurementAlias, 3);
                        }
                    }
                    catch (Exception e) {
                        paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
                    }
                    paths.clear();
                    dataTypes.clear();
                    encodings.clear();
                    compressors.clear();
                    measurementAlias.clear();
                    pointSize.set(0);
                }
            } else {
                paths.clear();
                dataTypes.clear();
                encodings.clear();
                compressors.clear();
                measurementAlias.clear();
            }
            String path = recordObj.get(headerNames.indexOf(Constants.HEAD_COLUMNS.get(0)));
            String alias = recordObj.get(headerNames.indexOf(Constants.HEAD_COLUMNS.get(1)));
            String dataTypeRaw = recordObj.get(headerNames.indexOf(Constants.HEAD_COLUMNS.get(2)));
            TSDataType dataType = ImportSchemaTree.typeInfer(dataTypeRaw);
            String encodingTypeRaw = recordObj.get(headerNames.indexOf(Constants.HEAD_COLUMNS.get(3)));
            TSEncoding encodingType = ImportSchemaTree.encodingInfer(encodingTypeRaw);
            String compressionTypeRaw = recordObj.get(headerNames.indexOf(Constants.HEAD_COLUMNS.get(4)));
            CompressionType compressionType = ImportSchemaTree.compressInfer(compressionTypeRaw);
            if (StringUtils.isBlank((CharSequence)path) || path.trim().startsWith("root.__system")) {
                ioTPrinter.println(String.format("Line '%s', column '%s': illegal path %s", recordObj.getRecordNumber(), headerNames, path));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)dataType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown dataType %n", recordObj.getRecordNumber(), path, dataTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)encodingType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown encodingType %n", recordObj.getRecordNumber(), path, encodingTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)compressionType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown compressionType %n", recordObj.getRecordNumber(), path, compressionTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else {
                if (StringUtils.isBlank((CharSequence)alias)) {
                    paths.add(path);
                    dataTypes.add(dataType);
                    encodings.add(encodingType);
                    compressors.add(compressionType);
                } else {
                    pathsWithAlias.add(path);
                    dataTypesWithAlias.add(dataType);
                    encodingsWithAlias.add(encodingType);
                    compressorsWithAlias.add(compressionType);
                    measurementAlias.add(alias);
                }
                pointSize.getAndIncrement();
            }
            if (!failed && aligned.booleanValue()) {
                String deviceId = path.substring(0, path.lastIndexOf("."));
                paths.add(0, path.substring(deviceId.length() + 1));
                ImportSchemaTree.writeAndEmptyDataSetAligned(deviceId, paths, dataTypes, encodings, compressors, measurementAlias, 3);
            }
        });
        try {
            if (CollectionUtils.isNotEmpty(paths)) {
                ImportSchemaTree.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, null, null, null, null, 3);
            }
        }
        catch (Exception e) {
            paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
        }
        try {
            if (CollectionUtils.isNotEmpty(pathsWithAlias)) {
                ImportSchemaTree.writeAndEmptyDataSet(pathsWithAlias, dataTypesWithAlias, encodingsWithAlias, compressorsWithAlias, null, null, null, measurementAlias, 3);
            }
        }
        catch (Exception e) {
            pathsWithAlias.forEach(t -> failedRecords.add(Collections.singletonList(t)));
        }
        pointSize.set(0);
        if (!failedRecords.isEmpty()) {
            ImportSchemaTree.writeFailedLinesFile(failedFilePath, failedRecords);
        }
        if (Boolean.TRUE.equals(hasStarted.get())) {
            if (!failedRecords.isEmpty()) {
                ioTPrinter.println(fileName + " : Import completely fail!");
            } else {
                ioTPrinter.println(fileName + " : Import completely successful!");
            }
        } else {
            ioTPrinter.println(fileName + " : No records!");
        }
    }

    private static void writeAndEmptyDataSet(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList, int retryTime) throws StatementExecutionException {
        try {
            sessionPool.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                ImportSchemaTree.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSetAligned(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, int retryTime) {
        try {
            sessionPool.createAlignedTimeseries(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList);
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                ImportSchemaTree.writeAndEmptyDataSetAligned(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
            System.exit(1);
        }
        finally {
            deviceId = null;
            measurements.clear();
            dataTypes.clear();
            encodings.clear();
            compressors.clear();
            measurementAliasList.clear();
        }
    }

    private static TSDataType typeInfer(String typeStr) {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeStr)) {
                return TSDataType.valueOf((String)typeStr);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static CompressionType compressInfer(String compressionType) {
        try {
            if (StringUtils.isNotBlank((CharSequence)compressionType)) {
                return CompressionType.valueOf((String)compressionType);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static TSEncoding encodingInfer(String encodingType) {
        try {
            if (StringUtils.isNotBlank((CharSequence)encodingType)) {
                return TSEncoding.valueOf((String)encodingType);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static void writeFailedLinesFile(String failedFilePath, ArrayList<List<Object>> failedRecords) {
        int failedRecordsSize;
        int fileIndex = 0;
        int from = 0;
        int restFailedRecords = failedRecordsSize = failedRecords.size();
        while (from < failedRecordsSize) {
            int step = Math.min(restFailedRecords, linesPerFailedFile);
            ImportSchemaTree.writeCsvFile(failedRecords.subList(from, from + step), failedFilePath + "_" + fileIndex++);
            from += step;
            restFailedRecords -= step;
        }
    }
}

