/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.auth;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AuthorTreePlan
extends AuthorPlan {
    protected Set<Integer> permissions;
    protected List<PartialPath> nodeNameList;

    public AuthorTreePlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public AuthorTreePlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String password, String newPassword, Set<Integer> permissions, boolean grantOpt, List<PartialPath> nodeNameList, Integer maxSessioPerUser, Integer minSessionPerUser) {
        super(authorType, userName, roleName, password, newPassword, grantOpt, maxSessioPerUser, minSessionPerUser);
        this.permissions = permissions;
        this.nodeNameList = nodeNameList;
    }

    public AuthorTreePlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String password, String newPassword, Set<Integer> permissions, boolean grantOpt, List<PartialPath> nodeNameList) {
        super(authorType, userName, roleName, password, newPassword, grantOpt, -1, -1);
        this.permissions = permissions;
        this.nodeNameList = nodeNameList;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public List<PartialPath> getNodeNameList() {
        return this.nodeNameList;
    }

    public void setNodeNameList(List<PartialPath> nodeNameList) {
        this.nodeNameList = nodeNameList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AuthorTreePlan) {
            AuthorTreePlan that = (AuthorTreePlan)o;
            return super.equals(that) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.nodeNameList, that.nodeNameList);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.permissions, this.nodeNameList);
    }

    @Override
    public String toString() {
        return "[type:" + (Object)((Object)super.getType()) + ", username:" + super.getUserName() + ", rolename:" + super.getRoleName() + ", permissions:" + PrivilegeType.toPriType(this.permissions) + ", grant option:" + super.getGrantOpt() + ", paths:" + this.nodeNameList + "]";
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getType().getPlanType(), (OutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.userName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.roleName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.password, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.newPassword, (DataOutputStream)stream);
        if (this.getAuthorType() == ConfigPhysicalPlanType.UpdateUserMaxSession || this.getAuthorType() == ConfigPhysicalPlanType.UpdateUserMinSession) {
            BasicStructureSerDeUtil.write((int)this.maxSessionPerUser, (DataOutputStream)stream);
            BasicStructureSerDeUtil.write((int)this.minSessionPerUser, (DataOutputStream)stream);
        }
        if (this.permissions == null) {
            stream.write(0);
        } else {
            stream.write(1);
            stream.writeInt(this.permissions.size());
            for (int permission : this.permissions) {
                stream.writeInt(permission);
            }
        }
        BasicStructureSerDeUtil.write((int)this.nodeNameList.size(), (DataOutputStream)stream);
        for (PartialPath partialPath : this.nodeNameList) {
            BasicStructureSerDeUtil.write((String)partialPath.getFullPath(), (DataOutputStream)stream);
        }
        BasicStructureSerDeUtil.write((int)(super.getGrantOpt() ? 1 : 0), (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        int i;
        this.userName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.roleName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.password = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.newPassword = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        if (this.getAuthorType() == ConfigPhysicalPlanType.UpdateUserMaxSession || this.getAuthorType() == ConfigPhysicalPlanType.UpdateUserMinSession) {
            this.maxSessionPerUser = buffer.getInt();
            this.minSessionPerUser = buffer.getInt();
        }
        if (buffer.get() == 0) {
            this.permissions = null;
        } else {
            int permissionsSize = buffer.getInt();
            this.permissions = new HashSet<Integer>();
            for (i = 0; i < permissionsSize; ++i) {
                this.permissions.add(buffer.getInt());
            }
        }
        int nodeNameListSize = BasicStructureSerDeUtil.readInt((ByteBuffer)buffer);
        this.nodeNameList = new ArrayList<PartialPath>(nodeNameListSize);
        try {
            for (i = 0; i < nodeNameListSize; ++i) {
                this.nodeNameList.add(new PartialPath(BasicStructureSerDeUtil.readString((ByteBuffer)buffer)));
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        if (super.getAuthorType().ordinal() >= ConfigPhysicalPlanType.CreateUser.ordinal()) {
            super.setGrantOpt(BasicStructureSerDeUtil.readInt((ByteBuffer)buffer) > 0);
        }
    }
}

