/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.plan.planner.memory.FakedMemoryReservationManager;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.read.filter.basic.Filter;

public class FakedFragmentInstanceContext
extends FragmentInstanceContext {
    public FakedFragmentInstanceContext(Filter timeFilter, DataRegion dataRegion) {
        super(0L, new FakedMemoryReservationManager(), timeFilter, dataRegion);
    }

    public QueryDataSource getSharedQueryDataSource(IFullPath sourcePath) throws QueryProcessException {
        if (this.sharedQueryDataSource == null) {
            this.initQueryDataSource(sourcePath);
        }
        return (QueryDataSource)this.sharedQueryDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initQueryDataSource(IFullPath sourcePath) throws QueryProcessException {
        this.dataRegion.tryReadLock(Long.MAX_VALUE);
        try {
            this.sharedQueryDataSource = this.dataRegion.query(Collections.singletonList(sourcePath), sourcePath.getDeviceId(), this, this.getGlobalTimeFilter(), null, Long.MAX_VALUE);
            if (this.sharedQueryDataSource != null) {
                ((QueryDataSource)this.sharedQueryDataSource).setSingleDevice(true);
                List<TsFileResource> tsFileList = ((QueryDataSource)this.sharedQueryDataSource).getSeqResources();
                if (tsFileList != null) {
                    for (TsFileResource tsFile : tsFileList) {
                        FileReaderManager.getInstance().increaseFileReaderReference(tsFile, tsFile.isClosed());
                    }
                }
                if ((tsFileList = ((QueryDataSource)this.sharedQueryDataSource).getUnseqResources()) != null) {
                    for (TsFileResource tsFile : tsFileList) {
                        FileReaderManager.getInstance().increaseFileReaderReference(tsFile, tsFile.isClosed());
                    }
                }
            }
        }
        finally {
            this.dataRegion.readUnlock();
        }
    }

    public void releaseSharedQueryDataSource() {
        if (this.sharedQueryDataSource != null) {
            List<TsFileResource> tsFileList = ((QueryDataSource)this.sharedQueryDataSource).getSeqResources();
            if (tsFileList != null) {
                for (TsFileResource tsFile : tsFileList) {
                    FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, tsFile.isClosed());
                }
            }
            if ((tsFileList = ((QueryDataSource)this.sharedQueryDataSource).getUnseqResources()) != null) {
                for (TsFileResource tsFile : tsFileList) {
                    FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, tsFile.isClosed());
                }
            }
            this.sharedQueryDataSource = null;
        }
    }

    @Override
    protected boolean checkIfModificationExists(TsFileResource tsFileResource) {
        return false;
    }
}

