/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.AbstractSessionBuilder;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.TableSession;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class TableSessionBuilder
extends AbstractSessionBuilder {
    private boolean enableCompression = false;
    private int connectionTimeoutInMs = 0;

    public TableSessionBuilder nodeUrls(List<String> nodeUrls) {
        this.nodeUrls = nodeUrls;
        return this;
    }

    public TableSessionBuilder username(String username) {
        this.username = username;
        return this;
    }

    public TableSessionBuilder password(String password) {
        this.pw = password;
        return this;
    }

    public TableSessionBuilder database(String database) {
        this.database = database;
        return this;
    }

    public TableSessionBuilder queryTimeoutInMs(long queryTimeoutInMs) {
        this.timeOut = queryTimeoutInMs;
        return this;
    }

    public TableSessionBuilder fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public TableSessionBuilder zoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public TableSessionBuilder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        return this;
    }

    public TableSessionBuilder thriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        return this;
    }

    public TableSessionBuilder enableRedirection(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
        return this;
    }

    public TableSessionBuilder enableAutoFetch(boolean enableAutoFetch) {
        this.enableAutoFetch = enableAutoFetch;
        return this;
    }

    public TableSessionBuilder maxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public TableSessionBuilder retryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
        return this;
    }

    public TableSessionBuilder useSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public TableSessionBuilder trustStore(String keyStore) {
        this.trustStore = keyStore;
        return this;
    }

    public TableSessionBuilder trustStorePwd(String keyStorePwd) {
        this.trustStorePwd = keyStorePwd;
        return this;
    }

    public TableSessionBuilder enableCompression(boolean enableCompression) {
        this.isIoTDBRpcCompressionEnabled = enableCompression;
        return this;
    }

    public TableSessionBuilder connectionTimeoutInMs(int connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        return this;
    }

    public TableSessionBuilder enableCompaction(boolean enableCompaction) {
        this.isThriftRpcCompactionEnabled = enableCompaction;
        return this;
    }

    public TableSessionBuilder withCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public TableSessionBuilder withTimeStampEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.TIMESTAMP, tsEncoding);
        return this;
    }

    public TableSessionBuilder withBooleanEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.BOOLEAN, tsEncoding);
        return this;
    }

    public TableSessionBuilder withInt32Encoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.INT32, tsEncoding);
        return this;
    }

    public TableSessionBuilder withInt64Encoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.INT64, tsEncoding);
        return this;
    }

    public TableSessionBuilder withFloatEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.FLOAT, tsEncoding);
        return this;
    }

    public TableSessionBuilder withDoubleEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.DOUBLE, tsEncoding);
        return this;
    }

    public TableSessionBuilder withStringEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.STRING, tsEncoding);
        return this;
    }

    public TableSessionBuilder withTextEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.TEXT, tsEncoding);
        return this;
    }

    public TableSessionBuilder withBlobEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.BLOB, tsEncoding);
        return this;
    }

    public TableSessionBuilder withDateEncoding(TSEncoding tsEncoding) {
        this.columnEncodersMap.put(TSDataType.DATE, tsEncoding);
        return this;
    }

    public TableSessionBuilder tabletCompressionMinRowSize(int tabletCompressionMinRowSize) {
        this.tabletCompressionMinRowSize = tabletCompressionMinRowSize;
        return this;
    }

    public ITableSession build() throws IoTDBConnectionException {
        if (this.nodeUrls == null) {
            this.nodeUrls = Collections.singletonList("localhost:6667");
        }
        this.sqlDialect = "table";
        Session newSession = new Session(this);
        newSession.enableIoTDBRpcCompression = this.isIoTDBRpcCompressionEnabled;
        newSession.tabletCompressionMinRowSize = this.tabletCompressionMinRowSize;
        try {
            newSession.open(this.isThriftRpcCompactionEnabled, this.connectionTimeoutInMs);
        }
        catch (IoTDBConnectionException e) {
            newSession.close();
            throw e;
        }
        return new TableSession(newSession);
    }
}

