/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.impl.pipe.util.PipeExternalSourceLoadBalancer;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMetaSyncProcedure
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeMetaSyncProcedure.class);
    private static final long MIN_EXECUTION_INTERVAL_MS = PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L / 2L;
    private static final AtomicLong LAST_EXECUTION_TIME = new AtomicLong(0L);

    @Override
    protected AtomicReference<PipeTaskInfo> acquireLockInternal(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        return configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().tryLock();
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        if (System.currentTimeMillis() - LAST_EXECUTION_TIME.get() < MIN_EXECUTION_INTERVAL_MS) {
            this.pipeTaskInfo = null;
            LOGGER.debug("PipeMetaSyncProcedure: acquireLock, skip the procedure due to the last execution time {}", (Object)LAST_EXECUTION_TIME.get());
            return ProcedureLockState.LOCK_ACQUIRED;
        }
        return super.acquireLock(configNodeProcedureEnv);
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.SYNC_PIPE_META;
    }

    @Override
    public boolean executeFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: executeFromValidateTask");
        LAST_EXECUTION_TIME.set(System.currentTimeMillis());
        return true;
    }

    @Override
    public void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: executeFromCalculateInfoForTask");
        ((PipeTaskInfo)this.pipeTaskInfo.get()).getPipeMetaList().forEach(pipeMeta -> {
            if (!pipeMeta.getStaticMeta().isSourceExternal()) {
                return;
            }
            PipeExternalSourceLoadBalancer loadBalancer = new PipeExternalSourceLoadBalancer(pipeMeta.getStaticMeta().getSourceParameters().getStringOrDefault(Arrays.asList("extractor.balance-strategy", "source.balance-strategy"), "proportion"));
            int parallelism = pipeMeta.getStaticMeta().getSourceParameters().getIntOrDefault(Arrays.asList("extractor.parallelism", "source.parallelism"), 1);
            ConcurrentMap consensusGroupIdToTaskMetaMap = pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            Map<Integer, Integer> taskId2LeaderDataNodeId = loadBalancer.balance(parallelism, pipeMeta.getStaticMeta(), ConfigNode.getInstance().getConfigManager());
            taskId2LeaderDataNodeId.forEach((taskIndex, newLeader) -> {
                if (consensusGroupIdToTaskMetaMap.containsKey(taskIndex)) {
                    ((PipeTaskMeta)consensusGroupIdToTaskMetaMap.get(taskIndex)).setLeaderNodeId(newLeader.intValue());
                } else {
                    consensusGroupIdToTaskMetaMap.put(taskIndex, new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, newLeader.intValue()));
                }
            });
            Set<Integer> taskIdToRemove = consensusGroupIdToTaskMetaMap.keySet().stream().filter(taskId -> !taskId2LeaderDataNodeId.containsKey(taskId)).collect(Collectors.toSet());
            taskIdToRemove.forEach(consensusGroupIdToTaskMetaMap::remove);
        });
    }

    @Override
    public void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.debug("PipeMetaSyncProcedure: executeFromWriteConfigNodeConsensus");
        ArrayList<PipeMeta> pipeMetaList = new ArrayList<PipeMeta>();
        for (PipeMeta pipeMeta : ((PipeTaskInfo)this.pipeTaskInfo.get()).getPipeMetaList()) {
            pipeMetaList.add(pipeMeta);
        }
        try {
            response = env.getConfigManager().getConsensusManager().write(new PipeHandleMetaChangePlan(pipeMetaList));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.debug("PipeMetaSyncProcedure: executeFromOperateOnDataNodes");
        Map<Integer, TPushPipeMetaResp> respMap = this.pushPipeMetaToDataNodes(env);
        if (((PipeTaskInfo)this.pipeTaskInfo.get()).recordDataNodePushPipeMetaExceptions(respMap)) {
            throw new PipeException(String.format("Failed to push pipe meta to dataNodes, details: %s", PipeMetaSyncProcedure.parsePushPipeMetaExceptionForPipe(null, respMap)));
        }
    }

    @Override
    public void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: rollbackFromValidateTask");
    }

    @Override
    public void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: rollbackFromCalculateInfoForTask");
    }

    @Override
    public void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: rollbackFromWriteConfigNodeConsensus");
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.debug("PipeMetaSyncProcedure: rollbackFromOperateOnDataNodes");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.PIPE_META_SYNC_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PipeMetaSyncProcedure;
    }

    public int hashCode() {
        return 0;
    }
}

