/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.AbstractBitwiseColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.BitwiseUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;

public class BitwiseLeftShiftColumnTransformer
extends AbstractBitwiseColumnTransformer {
    public BitwiseLeftShiftColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, long rightValue) {
        super(returnType, childColumnTransformer, rightValue);
    }

    @Override
    protected void transform(Column column, ColumnBuilder columnBuilder, int i) {
        if (TSDataType.INT32.equals((Object)column.getDataType())) {
            int leftValue = column.getInt(i);
            columnBuilder.writeInt(BitwiseUtils.bitwiseLeftShiftTransform(leftValue, this.rightValue));
        } else if (TSDataType.INT64.equals((Object)column.getDataType())) {
            long leftValue = column.getLong(i);
            columnBuilder.writeLong(BitwiseUtils.bitwiseLeftShiftTransform(leftValue, this.rightValue));
        }
    }
}

