/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.local;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public final class FileUtil {
    private FileUtil() {
    }

    public static void copy(File src, File dest) throws IOException {
        if (!src.canRead()) {
            throw new IOException(src.getPath() + " can't be read from.");
        }
        if (src.isDirectory()) {
            if (dest.isFile()) {
                throw new IOException("can't copy a folder to a file");
            }
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if (!dest.canWrite()) {
                throw new IOException("can't write to " + dest.getPath());
            }
            File[] children = src.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.copy(children[i], new File(dest, children[i].getName()));
            }
        } else {
            File destParent;
            if (dest.isDirectory()) {
                destParent = dest;
                dest = new File(destParent, src.getName());
            } else {
                destParent = dest.getParentFile();
            }
            if (!destParent.canWrite()) {
                throw new IOException("can't write to " + destParent.getPath());
            }
            FileUtils.copyFile(src, dest);
        }
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.delete(children[i]);
            }
        }
        if (!f.delete()) {
            throw new IOException("Unable to delete " + f.getPath());
        }
    }
}

