/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.FileRecordIterator;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.LockableFileRevision;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.journal.RotatingLogFile;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJournal
extends AbstractJournal {
    public static final String DEFAULT_INSTANCE_FILE_NAME = "revision.log";
    private static final String REVISION_NAME = "revision";
    private static final String LOG_EXTENSION = "log";
    private static final String DEFAULT_BASENAME = "journal";
    private static final int DEFAULT_MAXSIZE = 0x100000;
    private static Logger log = LoggerFactory.getLogger(FileJournal.class);
    private String directory;
    private String basename;
    private int maximumSize;
    private File rootDirectory;
    private File journalFile;
    private LockableFileRevision globalRevision;

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        Object msg;
        super.init(id, resolver);
        if (this.getRevision() == null) {
            File repHome = this.getRepositoryHome();
            if (repHome == null) {
                String msg2 = "Revision not specified.";
                throw new JournalException(msg2);
            }
            String revision = new File(repHome, DEFAULT_INSTANCE_FILE_NAME).getPath();
            log.info("Revision not specified, using: " + revision);
            this.setRevision(revision);
        }
        if (this.directory == null) {
            msg = "Directory not specified.";
            throw new JournalException((String)msg);
        }
        if (this.basename == null) {
            this.basename = DEFAULT_BASENAME;
        }
        if (this.maximumSize == 0) {
            this.maximumSize = 0x100000;
        }
        this.rootDirectory = new File(this.directory);
        this.rootDirectory.mkdirs();
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            msg = "Directory specified does either not exist or is not a directory: " + this.directory;
            throw new JournalException((String)msg);
        }
        this.journalFile = new File(this.rootDirectory, this.basename + ".log");
        this.globalRevision = new LockableFileRevision(new File(this.rootDirectory, REVISION_NAME));
        log.info("FileJournal initialized at path: " + this.directory);
    }

    protected long getGlobalRevision() throws JournalException {
        return this.globalRevision.get();
    }

    @Override
    public RecordIterator getRecords(long startRevision) throws JournalException {
        long stopRevision = this.getGlobalRevision();
        File[] files = null;
        if (startRevision < stopRevision) {
            RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
            files = new File[logFiles.length];
            for (int i = 0; i < files.length; ++i) {
                files[i] = logFiles[i].getFile();
            }
        }
        return new FileRecordIterator(files, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    @Override
    public RecordIterator getRecords() throws JournalException {
        long stopRevision = this.getGlobalRevision();
        long startRevision = 0L;
        RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
        File[] files = new File[logFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = logFiles[i].getFile();
            if (i != 0) continue;
            try {
                FileRecordLog log = new FileRecordLog(files[i]);
                startRevision = log.getPreviousRevision();
                continue;
            }
            catch (IOException e) {
                String msg = "Unable to read startRevision from first record log file";
                throw new JournalException(msg, e);
            }
        }
        return new FileRecordIterator(files, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    @Override
    protected void doLock() throws JournalException {
        this.globalRevision.lock(false);
    }

    @Override
    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            FileRecordLog recordLog = new FileRecordLog(this.journalFile);
            if (recordLog.exceeds(this.maximumSize)) {
                this.rotateLogs();
                recordLog = new FileRecordLog(this.journalFile);
            }
            if (recordLog.isNew()) {
                recordLog.init(this.globalRevision.get());
            }
            long revision = recordLog.append(this.getId(), record.getProducerId(), in, length);
            this.globalRevision.set(revision);
            record.setRevision(revision);
        }
        catch (IOException e) {
            String msg = "Unable to append new record to journal '" + String.valueOf(this.journalFile) + "'.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    protected void doUnlock(boolean successful) {
        this.globalRevision.unlock();
    }

    @Override
    public void close() {
    }

    @Override
    public InstanceRevision getInstanceRevision() throws JournalException {
        return new FileRevision(new File(this.getRevision()), true);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getBasename() {
        return this.basename;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    private void rotateLogs() {
        RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
        for (int i = 0; i < logFiles.length; ++i) {
            logFiles[i].rotate();
        }
    }
}

