/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.spi.ItemId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IdURICache {
    private static Logger log = LoggerFactory.getLogger(IdURICache.class);
    private static final int CACHESIZE = 10000;
    private final String workspaceUri;
    private Map<ItemId, String> idToUriCache;
    private Map<String, ItemId> uriToIdCache;

    IdURICache(String workspaceUri) {
        this.workspaceUri = workspaceUri;
        this.idToUriCache = new LRULinkedHashMap<ItemId, String>(10000, 1.0f);
        this.uriToIdCache = new LRULinkedHashMap<String, ItemId>(10000, 1.0f);
    }

    public ItemId getItemId(String uri) {
        return this.uriToIdCache.get(IdURICache.getCleanUri(uri));
    }

    public String getUri(ItemId itemId) {
        return this.idToUriCache.get(itemId);
    }

    public boolean containsUri(String uri) {
        return this.uriToIdCache.containsKey(IdURICache.getCleanUri(uri));
    }

    public boolean containsItemId(ItemId itemId) {
        return this.idToUriCache.containsKey(itemId);
    }

    public void add(String uri, ItemId itemId) {
        String cleanUri = this.checkedIsUnderWorkspace(IdURICache.getCleanUri(uri));
        this.uriToIdCache.put(cleanUri, itemId);
        this.idToUriCache.put(itemId, cleanUri);
        log.debug("Added: ItemId = " + String.valueOf(itemId) + " URI = " + cleanUri);
    }

    public void remove(String uri) {
        String cleanUri = IdURICache.getCleanUri(uri);
        ItemId itemId = this.uriToIdCache.remove(cleanUri);
        if (itemId != null) {
            this.idToUriCache.remove(itemId);
        }
        log.debug("Removed: ItemId = " + String.valueOf(itemId) + " URI = " + cleanUri);
    }

    public void remove(ItemId itemId) {
        String uri = this.idToUriCache.remove(itemId);
        if (uri != null) {
            this.uriToIdCache.remove(uri);
        }
        log.debug("Removed: ItemId = " + String.valueOf(itemId) + " URI = " + uri);
    }

    public void clear() {
        this.idToUriCache.clear();
        this.uriToIdCache.clear();
    }

    private String checkedIsUnderWorkspace(String uri) {
        if (uri.startsWith(this.workspaceUri)) {
            return uri;
        }
        int ml = Math.max(uri.length(), this.workspaceUri.length());
        int match = 0;
        int i = 0;
        while (i < ml && uri.charAt(i) == this.workspaceUri.charAt(i)) {
            match = i++;
        }
        String diags = "";
        if (uri.length() > match) {
            String expected = this.workspaceUri.length() > match ? String.format(", expected: '%s'", this.workspaceUri.substring(match + 1)) : "";
            diags = String.format(" (position %d: '{%s}%s'%s)", match, uri.substring(0, match + 1), uri.substring(match + 1), expected);
        }
        throw new IllegalArgumentException("Workspace mismatch: '" + uri + "' not under workspace '" + this.workspaceUri + "'" + diags);
    }

    private static String getCleanUri(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private class LRULinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 4463208266433931306L;
        private int capacity;

        LRULinkedHashMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

