/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayBufferTest {
    @Test
    public void testConstructor() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertNotNull((Object)buffer.buffer());
        Assert.assertEquals((long)16L, (long)buffer.buffer().length);
        try {
            new ByteArrayBuffer(-1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        byte[] b1 = buffer.toByteArray();
        Assert.assertNotNull((Object)b1);
        Assert.assertEquals((long)0L, (long)b1.length);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, tmp.length);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)4L, (long)buffer.length());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        byte[] b2 = buffer.toByteArray();
        Assert.assertNotNull((Object)b2);
        Assert.assertEquals((long)4L, (long)b2.length);
        for (int i = 0; i < tmp.length; ++i) {
            Assert.assertEquals((long)tmp[i], (long)b2[i]);
            Assert.assertEquals((long)tmp[i], (long)buffer.byteAt(i));
        }
        buffer.clear();
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testExpandAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, 2);
        buffer.append(tmp, 0, 4);
        buffer.append(tmp, 0, 0);
        Assert.assertEquals((long)8L, (long)buffer.capacity());
        Assert.assertEquals((long)6L, (long)buffer.length());
        buffer.append(tmp, 0, 4);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)10L, (long)buffer.length());
    }

    @Test
    public void testInvalidAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{1, 2, 3, 4};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testAppendOneByte() throws Exception {
        byte[] tmp;
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        for (byte b : tmp = new byte[]{1, 127, -1, -128, 1, -2}) {
            buffer.append((int)b);
        }
        Assert.assertEquals((long)8L, (long)buffer.capacity());
        Assert.assertEquals((long)6L, (long)buffer.length());
        for (int i = 0; i < tmp.length; ++i) {
            Assert.assertEquals((long)tmp[i], (long)buffer.byteAt(i));
        }
    }

    @Test
    public void testSetLength() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.setLength(2);
        Assert.assertEquals((long)2L, (long)buffer.length());
    }

    @Test
    public void testSetInvalidLength() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        try {
            buffer.setLength(-2);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.setLength(200);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() throws Exception {
        ByteArrayBuffer b = new ByteArrayBuffer(16);
        byte[] tmp = "--+++-".getBytes("US-ASCII");
        b.append(tmp, 0, tmp.length);
        b.remove(2, 3);
        Assert.assertEquals((long)3L, (long)b.length());
        Assert.assertEquals((Object)"---", (Object)new String(b.buffer(), 0, b.length(), "US-ASCII"));
        b.remove(2, 1);
        b.remove(1, 1);
        b.remove(0, 1);
        Assert.assertEquals((long)0L, (long)b.length());
        tmp = "+++---".getBytes("US-ASCII");
        b.append(tmp, 0, tmp.length);
        b.remove(0, 3);
        Assert.assertEquals((long)3L, (long)b.length());
        Assert.assertEquals((Object)"---", (Object)new String(b.buffer(), 0, b.length(), "US-ASCII"));
        b.remove(0, 3);
        Assert.assertEquals((long)0L, (long)b.length());
        tmp = "---+++".getBytes("US-ASCII");
        b.append(tmp, 0, tmp.length);
        b.remove(3, 3);
        Assert.assertEquals((long)3L, (long)b.length());
        Assert.assertEquals((Object)"---", (Object)new String(b.buffer(), 0, b.length(), "US-ASCII"));
        b.remove(0, 3);
        Assert.assertEquals((long)0L, (long)b.length());
    }

    @Test
    public void testInvalidRemove() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        buffer.setLength(8);
        try {
            buffer.remove(-1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.remove(0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.remove(0, 9);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            buffer.remove(10, 2);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

