/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.quota;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.backends.postgres.quota.PostgresQuotaCurrentValueDAO;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaType;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import reactor.core.publisher.Mono;

public class PostgresCurrentQuotaManager
implements CurrentQuotaManager {
    private final PostgresQuotaCurrentValueDAO currentValueDao;

    @Inject
    public PostgresCurrentQuotaManager(PostgresQuotaCurrentValueDAO currentValueDao) {
        this.currentValueDao = currentValueDao;
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        return this.currentValueDao.getQuotaCurrentValue(this.asQuotaKeyCount(quotaRoot)).map(QuotaCurrentValue::getCurrentValue).map(QuotaCountUsage::count).defaultIfEmpty((Object)QuotaCountUsage.count((long)0L));
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        return this.currentValueDao.getQuotaCurrentValue(this.asQuotaKeySize(quotaRoot)).map(QuotaCurrentValue::getCurrentValue).map(QuotaSizeUsage::size).defaultIfEmpty((Object)QuotaSizeUsage.size((long)0L));
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        return this.currentValueDao.getQuotaCurrentValues(QuotaComponent.MAILBOX, quotaRoot.asString()).collectList().map(this::buildCurrentQuotas);
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return this.currentValueDao.increase(this.asQuotaKeyCount(quotaOperation.quotaRoot()), quotaOperation.count().asLong()).then(this.currentValueDao.increase(this.asQuotaKeySize(quotaOperation.quotaRoot()), quotaOperation.size().asLong()));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return this.currentValueDao.decrease(this.asQuotaKeyCount(quotaOperation.quotaRoot()), quotaOperation.count().asLong()).then(this.currentValueDao.decrease(this.asQuotaKeySize(quotaOperation.quotaRoot()), quotaOperation.size().asLong()));
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return this.getCurrentQuotas(quotaOperation.quotaRoot()).filter(Predicate.not(Predicate.isEqual(CurrentQuotas.from((QuotaOperation)quotaOperation)))).flatMap(storedQuotas -> {
            long count = quotaOperation.count().asLong() - storedQuotas.count().asLong();
            long size = quotaOperation.size().asLong() - storedQuotas.size().asLong();
            return this.currentValueDao.increase(this.asQuotaKeyCount(quotaOperation.quotaRoot()), count).then(this.currentValueDao.increase(this.asQuotaKeySize(quotaOperation.quotaRoot()), size));
        });
    }

    private QuotaCurrentValue.Key asQuotaKeyCount(QuotaRoot quotaRoot) {
        return this.asQuotaKey(quotaRoot, QuotaType.COUNT);
    }

    private QuotaCurrentValue.Key asQuotaKeySize(QuotaRoot quotaRoot) {
        return this.asQuotaKey(quotaRoot, QuotaType.SIZE);
    }

    private QuotaCurrentValue.Key asQuotaKey(QuotaRoot quotaRoot, QuotaType quotaType) {
        return QuotaCurrentValue.Key.of((QuotaComponent)QuotaComponent.MAILBOX, (String)quotaRoot.asString(), (QuotaType)quotaType);
    }

    private CurrentQuotas buildCurrentQuotas(List<QuotaCurrentValue> quotaCurrentValues) {
        QuotaCountUsage count = this.extractQuotaByType(quotaCurrentValues, QuotaType.COUNT).map(value -> QuotaCountUsage.count((long)value.getCurrentValue())).orElse(QuotaCountUsage.count((long)0L));
        QuotaSizeUsage size = this.extractQuotaByType(quotaCurrentValues, QuotaType.SIZE).map(value -> QuotaSizeUsage.size((long)value.getCurrentValue())).orElse(QuotaSizeUsage.size((long)0L));
        return new CurrentQuotas(count, size);
    }

    private Optional<QuotaCurrentValue> extractQuotaByType(List<QuotaCurrentValue> quotaCurrentValues, QuotaType quotaType) {
        return quotaCurrentValues.stream().filter(quotaValue -> quotaValue.getQuotaType().equals((Object)quotaType)).findAny();
    }
}

