/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;

public class IteratorConcat<T>
implements IteratorCloseable<T> {
    private List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    int idx = -1;
    private Iterator<T> current = null;
    boolean finished = false;

    public static <T> Iterator<T> concat(Iterator<T> iter1, Iterator<T> iter2) {
        if (iter2 == null) {
            return iter1;
        }
        if (iter1 == null) {
            return iter2;
        }
        IteratorConcat<T> c = new IteratorConcat<T>();
        c.add(iter1);
        c.add(iter2);
        return c;
    }

    public void add(Iterator<T> iter) {
        this.iterators.add(iter);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        if (this.current != null) {
            Iter.close(this.current);
        }
        ++this.idx;
        this.current = null;
        while (this.idx < this.iterators.size()) {
            this.current = this.iterators.get(this.idx);
            if (this.current.hasNext()) {
                return true;
            }
            this.current = null;
            ++this.idx;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.current.forEachRemaining(action);
            Iter.close(this.current);
        }
        ++this.idx;
        while (this.idx < this.iterators.size()) {
            this.current = this.iterators.get(this.idx);
            this.current.forEachRemaining(action);
            Iter.close(this.current);
            ++this.idx;
        }
        this.current = null;
        this.finished = true;
    }

    @Override
    public void close() {
        for (int i = this.idx; i < this.iterators.size(); ++i) {
            Iterator<T> iter = this.iterators.get(this.idx);
            Iter.close(iter);
        }
    }
}

