/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1;

import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.GraphTDB;
import org.apache.jena.tdb1.store.bulkloader.BulkLoader;
import org.apache.jena.tdb1.sys.TDBInternal;

@Deprecated(forRemoval=true)
public class TDB1Loader {
    private boolean showProgress = true;
    private boolean generateStats = true;
    private boolean checking;

    public static void load(DatasetGraphTDB dataset, String url) {
        TDB1Loader.load(dataset, url, false);
    }

    public static void load(DatasetGraphTDB dataset, String url, boolean showProgress) {
        TDB1Loader.load(dataset, List.of(url), showProgress, true);
    }

    public static void load(DatasetGraphTDB dataset, List<String> urls) {
        TDB1Loader.load(dataset, urls, false, true);
    }

    public static void load(DatasetGraphTDB dataset, List<String> urls, boolean showProgress, boolean generateStats) {
        TDB1Loader loader = new TDB1Loader();
        loader.setShowProgress(showProgress);
        loader.setGenerateStats(generateStats);
        loader.loadDataset(dataset, urls);
    }

    public static void load(DatasetGraphTDB dataset, InputStream input, Lang lang, boolean showProgress, boolean generateStats) {
        TDB1Loader loader = new TDB1Loader();
        loader.setShowProgress(showProgress);
        loader.setGenerateStats(generateStats);
        loader.loadDataset(dataset, input, lang);
    }

    public static void load(GraphTDB graph, String url) {
        TDB1Loader.load(graph, url, false);
    }

    public static void load(GraphTDB graph, String url, boolean showProgress) {
        TDB1Loader.load(graph, List.of(url), showProgress);
    }

    public static void load(GraphTDB graph, List<String> urls) {
        TDB1Loader.load(graph, urls, false);
    }

    public static void load(GraphTDB graph, List<String> urls, boolean showProgress) {
        TDB1Loader loader = new TDB1Loader();
        loader.setShowProgress(showProgress);
        loader.loadGraph(graph, urls);
    }

    public static void loadModel(Model model, String url) {
        TDB1Loader.loadModel(model, url, false);
    }

    public static void loadModel(Model model, String url, boolean showProgress) {
        TDB1Loader.loadAnything(model, url, showProgress);
    }

    public static void loadModel(Model model, List<String> urls, boolean showProgress) {
        Timer timer = new Timer();
        timer.startTimer();
        for (String s : urls) {
            if (showProgress) {
                System.out.printf("Load: %s\n", s);
            }
            TDB1Loader.loadModel(model, s, showProgress);
        }
        long time = timer.endTimer();
        if (showProgress) {
            System.out.printf("Time for load: %.2fs\n", (double)time / 1000.0);
        }
        model.close();
    }

    public void loadGraph(GraphTDB graph, String url) {
        this.loadGraph(graph, List.of(url));
    }

    public void loadGraph(GraphTDB graph, List<String> urls) {
        TDB1Loader.loadGraph$(graph, urls, this.showProgress, this.generateStats);
    }

    public void loadGraph(GraphTDB graph, InputStream in) {
        TDB1Loader.loadGraph$(graph, in, this.showProgress, this.generateStats);
    }

    public void loadDataset(DatasetGraphTDB dataset, String url) {
        this.loadDataset(dataset, List.of(url));
    }

    public void loadDataset(DatasetGraphTDB dataset, List<String> urls) {
        TDB1Loader.loadDataset$(dataset, urls, this.showProgress, this.generateStats);
    }

    public void loadDataset(DatasetGraphTDB dataset, InputStream input, Lang lang) {
        TDB1Loader.loadDataset$(dataset, input, lang, this.showProgress, this.generateStats);
    }

    public boolean getChecking() {
        return this.checking;
    }

    public void setChecking(boolean checking) {
        this.checking = checking;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public final void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public final boolean getGenerateStats() {
        return this.generateStats;
    }

    public final void setGenerateStats(boolean generateStats) {
        this.generateStats = generateStats;
    }

    private static void loadGraph$(GraphTDB graph, List<String> urls, boolean showProgress, boolean collectStats) {
        if (graph.getGraphName() == null) {
            TDB1Loader.loadDefaultGraph$(graph.getDatasetGraphTDB(), urls, showProgress, collectStats);
        } else {
            TDB1Loader.loadNamedGraph$(graph.getDatasetGraphTDB(), graph.getGraphName(), urls, showProgress, collectStats);
        }
    }

    private static void loadGraph$(GraphTDB graph, InputStream input, boolean showProgress, boolean collectStats) {
        DatasetGraphTDB dsgtdb = TDBInternal.getBaseDatasetGraphTDB((DatasetGraph)graph.getDatasetGraphTDB());
        if (graph.getGraphName() == null) {
            TDB1Loader.loadDefaultGraph$(dsgtdb, input, showProgress, collectStats);
        } else {
            TDB1Loader.loadNamedGraph$(dsgtdb, graph.getGraphName(), input, showProgress, collectStats);
        }
    }

    private static void loadDefaultGraph$(DatasetGraphTDB dataset, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkLoader.loadDefaultGraph(dataset, urls, showProgress, collectStats);
    }

    private static void loadDefaultGraph$(DatasetGraphTDB dataset, InputStream input, boolean showProgress, boolean collectStats) {
        BulkLoader.loadDefaultGraph(dataset, input, showProgress, collectStats);
    }

    private static void loadNamedGraph$(DatasetGraphTDB dataset, Node graphName, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkLoader.loadNamedGraph(dataset, graphName, urls, showProgress, collectStats);
    }

    private static void loadNamedGraph$(DatasetGraphTDB dataset, Node graphName, InputStream input, boolean showProgress, boolean collectStats) {
        BulkLoader.loadNamedGraph(dataset, graphName, input, showProgress, collectStats);
    }

    private static void loadDataset$(DatasetGraphTDB dataset, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkLoader.loadDataset(dataset, urls, showProgress, collectStats);
    }

    private static void loadDataset$(DatasetGraphTDB dataset, InputStream input, Lang lang, boolean showProgress, boolean collectStats) {
        BulkLoader.loadDataset(dataset, input, lang, showProgress, collectStats);
    }

    private static void loadAnything(Model model, String url, boolean showProgress) {
        model.read(url);
    }
}

