/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.command.ModuleAddCommand;
import org.apache.karaf.jaas.command.completers.LoginModuleNameCompleter;
import org.apache.karaf.jaas.command.completers.RealmCompleter;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.config.impl.Config;
import org.apache.karaf.jaas.config.impl.Module;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;

@Command(scope="jaas", name="realm-add", description="Add a realm")
@Service
public class RealmAddCommand
extends JaasCommandSupport {
    @Reference
    private BundleContext context;
    @Argument(index=0, name="realmname", description="Realm Name", required=true, multiValued=false)
    @Completion(value=RealmCompleter.class)
    private String realmname;
    @Argument(index=1, name="loginModule", description="Class Name of Login Module", required=true, multiValued=false)
    @Completion(value=LoginModuleNameCompleter.class)
    private String loginModule;
    @Argument(index=2, name="properties", description="Pair of Properties (key value)", required=false, multiValued=true)
    private List<String> propertiesList;

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }

    @Override
    public Object execute() throws Exception {
        Module initialModule = ModuleAddCommand.createModuleFromCmdParameters(this.loginModule, this.propertiesList);
        if (initialModule == null) {
            return null;
        }
        Config realm = new Config();
        realm.setName(this.realmname);
        realm.setModules(new Module[]{initialModule});
        realm.setBundleContext(this.context);
        this.context.registerService(JaasRealm.class, (Object)realm, null);
        return null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public String getRealmname() {
        return this.realmname;
    }

    public void setRealmname(String realmname) {
        this.realmname = realmname;
    }

    public String toString() {
        return "RealmAddCommand{realmname='" + this.realmname + '\'' + '}';
    }
}

