/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;

public class DirectoryHandle
extends Handle
implements Iterator<Path> {
    private boolean done;
    private boolean sendDotDot = true;
    private boolean sendDot = true;
    private DirectoryStream<Path> ds;
    private Iterator<Path> fileList;

    public DirectoryHandle(SftpSubsystem subsystem, Path dir, String handle) throws IOException {
        super(dir, handle);
        this.signalHandleOpening(subsystem);
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        ServerSession session = subsystem.getServerSession();
        this.ds = accessor.openDirectory(session, subsystem, dir, handle);
        Path parent = dir.getParent();
        if (parent == null) {
            this.sendDotDot = false;
        }
        this.fileList = this.ds.iterator();
        try {
            this.signalHandleOpen(subsystem);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void markDone() {
        this.done = true;
        this.fileList = null;
    }

    public boolean isSendDot() {
        return this.sendDot;
    }

    public void markDotSent() {
        this.sendDot = false;
    }

    public boolean isSendDotDot() {
        return this.sendDotDot;
    }

    public void markDotDotSent() {
        this.sendDotDot = false;
    }

    @Override
    public boolean hasNext() {
        return this.fileList.hasNext();
    }

    @Override
    public Path next() {
        return this.fileList.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not allowed to remove " + this.toString());
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.markDone();
        this.ds.close();
    }
}

