/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.maven;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.logging.log4j.changelog.maven.AbstractChangelogMojo;
import org.apache.logging.log4j.changelog.releaser.ChangelogReleaser;
import org.apache.logging.log4j.changelog.releaser.ChangelogReleaserArgs;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="release", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public final class ReleaseMojo
extends AbstractChangelogMojo {
    @Parameter(property="log4j.changelog.releaseVersion", required=true)
    private String releaseVersion;
    @Parameter(property="log4j.changelog.versionPattern")
    private String versionPattern;

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping changelog release");
            return;
        }
        Pattern compiledVersionPattern = this.versionPattern != null ? Pattern.compile(this.versionPattern) : null;
        ChangelogReleaserArgs args = new ChangelogReleaserArgs(this.changelogDirectory.toPath(), this.releaseVersion, compiledVersionPattern, LocalDate.now(ZoneId.systemDefault()));
        ChangelogReleaser.performRelease((ChangelogReleaserArgs)args);
    }
}

