/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.CallbackListener;
import org.apache.myfaces.renderkit.html.util.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.renderkit.html.util.MyFacesResourceHandler;
import org.apache.myfaces.renderkit.html.util.NonBufferingAddResource;
import org.apache.myfaces.renderkit.html.util.ReducedHTMLParser;
import org.apache.myfaces.renderkit.html.util.ResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourcePosition;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlResponseWriterImpl;

public class DefaultAddResource
extends NonBufferingAddResource {
    protected Log log = LogFactory.getLog((Class)DefaultAddResource.class);
    protected StringBuffer originalResponse;
    private Set headerBeginInfo;
    private Set bodyEndInfo;
    private Set bodyOnloadInfo;
    protected boolean parserCalled = false;
    protected int headerInsertPosition = -1;
    protected int bodyInsertPosition = -1;
    protected int beforeBodyPosition = -1;
    protected int afterBodyContentInsertPosition = -1;
    protected int beforeBodyEndPosition = -1;

    protected DefaultAddResource() {
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.addJavaScriptAtPosition(context, position, resourceHandler, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptAtPositionPlain(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), false, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName, boolean defer) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), defer);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri) {
        this.addJavaScriptAtPosition(context, position, uri, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri, boolean defer) {
        this.addPositionedInfo(position, this.getScriptInstance(context, uri, defer));
    }

    public void addJavaScriptToBodyTag(FacesContext context, String javascriptEventName, String addedJavaScript) {
        AttributeInfo info = new AttributeInfo();
        info.setAttributeName(javascriptEventName);
        info.setAttributeValue(addedJavaScript);
        this.addPositionedInfo(BODY_ONLOAD, info);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getScriptInstance(context, resourceHandler, defer));
    }

    private void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer, boolean encodeUrl) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getScriptInstance(context, resourceHandler, defer, encodeUrl));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addStyleSheet(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, String uri) {
        this.addPositionedInfo(position, this.getStyleInstance(context, uri));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getStyleInstance(context, resourceHandler));
    }

    public void addInlineStyleAtPosition(FacesContext context, ResourcePosition position, String inlineStyle) {
        this.addPositionedInfo(position, this.getInlineStyleInstance(inlineStyle));
    }

    public void addInlineScriptAtPosition(FacesContext context, ResourcePosition position, String inlineScript) {
        this.addPositionedInfo(position, this.getInlineScriptInstance(inlineScript));
    }

    protected Set getHeaderBeginInfos() {
        if (this.headerBeginInfo == null) {
            this.headerBeginInfo = new LinkedHashSet();
        }
        return this.headerBeginInfo;
    }

    protected Set getBodyEndInfos() {
        if (this.bodyEndInfo == null) {
            this.bodyEndInfo = new LinkedHashSet();
        }
        return this.bodyEndInfo;
    }

    protected Set getBodyOnloadInfos() {
        if (this.bodyOnloadInfo == null) {
            this.bodyOnloadInfo = new LinkedHashSet();
        }
        return this.bodyOnloadInfo;
    }

    private void addPositionedInfo(ResourcePosition position, PositionedInfo info) {
        if (HEADER_BEGIN.equals(position)) {
            Set set = this.getHeaderBeginInfos();
            set.add(info);
        } else if (BODY_END.equals(position)) {
            Set set = this.getBodyEndInfos();
            set.add(info);
        } else if (BODY_ONLOAD.equals(position)) {
            Set set = this.getBodyOnloadInfos();
            set.add(info);
        }
    }

    public boolean hasHeaderBeginInfos() {
        return this.headerBeginInfo != null;
    }

    public void parseResponse(HttpServletRequest request, String bufferedResponse, HttpServletResponse response) {
        this.originalResponse = new StringBuffer(bufferedResponse);
        ParseCallbackListener l = new ParseCallbackListener();
        ReducedHTMLParser.parse(this.originalResponse, l);
        this.headerInsertPosition = l.getHeaderInsertPosition();
        this.bodyInsertPosition = l.getBodyInsertPosition();
        this.beforeBodyPosition = l.getBeforeBodyPosition();
        this.afterBodyContentInsertPosition = l.getAfterBodyContentInsertPosition();
        this.beforeBodyEndPosition = l.getAfterBodyEndPosition() - 7;
        this.parserCalled = true;
    }

    public void writeMyFacesJavascriptBeforeBodyEnd(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.parserCalled) {
            throw new IOException("Method parseResponse has to be called first");
        }
        if (this.beforeBodyEndPosition >= 0) {
            String myFacesJavascript = (String)request.getAttribute("org.apache.myfaces.myFacesJavascript");
            if (myFacesJavascript != null) {
                this.originalResponse.insert(this.beforeBodyEndPosition, myFacesJavascript);
            } else {
                this.log.warn((Object)"MyFaces special javascript could not be retrieved from request-map.");
            }
        }
    }

    public void writeWithFullHeader(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Iterator i;
        HtmlBufferResponseWriterWrapper writerWrapper;
        if (!this.parserCalled) {
            throw new IOException("Method parseResponse has to be called first");
        }
        boolean addHeaderTags = false;
        if (this.headerInsertPosition == -1) {
            if (this.beforeBodyPosition != -1) {
                addHeaderTags = true;
                this.headerInsertPosition = this.beforeBodyPosition;
            } else {
                this.log.warn((Object)("Response has no <head> or <body> tag:\n" + this.originalResponse));
            }
        }
        HtmlResponseWriterImpl writer = new HtmlResponseWriterImpl(response.getWriter(), HtmlRendererUtils.selectContentType(request.getHeader("accept")), response.getCharacterEncoding());
        if (this.afterBodyContentInsertPosition >= 0) {
            writerWrapper = HtmlBufferResponseWriterWrapper.getInstance(writer);
            i = this.getBodyEndInfos().iterator();
            while (i.hasNext()) {
                writerWrapper.write("\n");
                PositionedInfo positionedInfo = (PositionedInfo)i.next();
                if (!(positionedInfo instanceof WritablePositionedInfo)) {
                    throw new IllegalStateException("positionedInfo of type : " + positionedInfo.getClass().getName());
                }
                ((WritablePositionedInfo)positionedInfo).writePositionedInfo(response, writerWrapper);
            }
            this.originalResponse.insert(this.headerInsertPosition, writerWrapper.toString());
        }
        if (this.bodyInsertPosition > 0) {
            StringBuffer buf = new StringBuffer();
            Set bodyInfos = this.getBodyOnloadInfos();
            if (bodyInfos.size() > 0) {
                int i2 = 0;
                Iterator it = this.getBodyOnloadInfos().iterator();
                while (it.hasNext()) {
                    AttributeInfo positionedInfo = (AttributeInfo)it.next();
                    if (i2 == 0) {
                        buf.append(positionedInfo.getAttributeName());
                        buf.append("=\"");
                    }
                    buf.append(positionedInfo.getAttributeValue());
                    ++i2;
                }
                buf.append("\"");
                this.originalResponse.insert(this.bodyInsertPosition - 1, " " + buf.toString());
            }
        }
        if (this.headerInsertPosition >= 0) {
            writerWrapper = HtmlBufferResponseWriterWrapper.getInstance(writer);
            if (addHeaderTags) {
                writerWrapper.write("<head>");
            }
            i = this.getHeaderBeginInfos().iterator();
            while (i.hasNext()) {
                writerWrapper.write("\n");
                PositionedInfo positionedInfo = (PositionedInfo)i.next();
                if (!(positionedInfo instanceof WritablePositionedInfo)) {
                    throw new IllegalStateException("positionedInfo of type : " + positionedInfo.getClass().getName());
                }
                ((WritablePositionedInfo)positionedInfo).writePositionedInfo(response, writerWrapper);
            }
            if (addHeaderTags) {
                writerWrapper.write("</head>");
            }
            this.originalResponse.insert(this.headerInsertPosition, writerWrapper.toString());
        }
    }

    public void writeResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HtmlResponseWriterImpl writer = new HtmlResponseWriterImpl(response.getWriter(), HtmlRendererUtils.selectContentType(request.getHeader("accept")), response.getCharacterEncoding());
        writer.write(this.originalResponse.toString());
    }

    private PositionedInfo getStyleInstance(FacesContext context, ResourceHandler resourceHandler) {
        return new StylePositionedInfo(this.getResourceUri(context, resourceHandler));
    }

    private PositionedInfo getScriptInstance(FacesContext context, ResourceHandler resourceHandler, boolean defer) {
        return new ScriptPositionedInfo(this.getResourceUri(context, resourceHandler), defer);
    }

    private PositionedInfo getScriptInstance(FacesContext context, ResourceHandler resourceHandler, boolean defer, boolean encodeURL) {
        return new ScriptPositionedInfo(this.getResourceUri(context, resourceHandler), defer, encodeURL);
    }

    private PositionedInfo getStyleInstance(FacesContext context, String uri) {
        return new StylePositionedInfo(this.getResourceUri(context, uri));
    }

    protected PositionedInfo getScriptInstance(FacesContext context, String uri, boolean defer) {
        return new ScriptPositionedInfo(this.getResourceUri(context, uri), defer);
    }

    private PositionedInfo getInlineScriptInstance(String inlineScript) {
        return new InlineScriptPositionedInfo(inlineScript);
    }

    private PositionedInfo getInlineStyleInstance(String inlineStyle) {
        return new InlineStylePositionedInfo(inlineStyle);
    }

    public boolean requiresBuffer() {
        return true;
    }

    public void responseStarted() {
    }

    public void responseFinished() {
    }

    protected static class ParseCallbackListener
    implements CallbackListener {
        private int headerInsertPosition = -1;
        private int bodyInsertPosition = -1;
        private int beforeBodyPosition = -1;
        private int afterBodyContentInsertPosition = -1;
        private int afterBodyEndPosition = -1;

        public void openedStartTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.beforeBodyPosition = charIndex;
            }
        }

        public void closedStartTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 1) {
                this.headerInsertPosition = charIndex;
            } else if (tagIdentifier == 0) {
                this.bodyInsertPosition = charIndex;
            }
        }

        public void openedEndTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.afterBodyContentInsertPosition = charIndex;
            }
        }

        public void closedEndTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.afterBodyEndPosition = charIndex;
            }
        }

        public void attribute(int charIndex, int tagIdentifier, String key, String value) {
        }

        public int getHeaderInsertPosition() {
            return this.headerInsertPosition;
        }

        public int getBodyInsertPosition() {
            return this.bodyInsertPosition;
        }

        public int getBeforeBodyPosition() {
            return this.beforeBodyPosition;
        }

        public int getAfterBodyContentInsertPosition() {
            return this.afterBodyContentInsertPosition;
        }

        public int getAfterBodyEndPosition() {
            return this.afterBodyEndPosition;
        }
    }

    private class InlineStylePositionedInfo
    extends InlinePositionedInfo {
        protected InlineStylePositionedInfo(String inlineStyle) {
            super(inlineStyle);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            NonBufferingAddResource.writeInlineStylesheet(writer, this.getInlineValue());
        }
    }

    private class InlineScriptPositionedInfo
    extends InlinePositionedInfo {
        protected InlineScriptPositionedInfo(String inlineScript) {
            super(inlineScript);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            NonBufferingAddResource.writeInlineScript(writer, this.getInlineValue());
        }
    }

    private abstract class InlinePositionedInfo
    implements WritablePositionedInfo {
        private final String _inlineValue;

        protected InlinePositionedInfo(String inlineValue) {
            this._inlineValue = inlineValue;
        }

        public String getInlineValue() {
            return this._inlineValue;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this._inlineValue).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlinePositionedInfo) {
                InlinePositionedInfo other = (InlinePositionedInfo)obj;
                return new EqualsBuilder().append((Object)this._inlineValue, (Object)other._inlineValue).isEquals();
            }
            return false;
        }
    }

    private class ScriptPositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo {
        protected final boolean _defer;
        protected final boolean _encode;

        public ScriptPositionedInfo(String resourceUri, boolean defer) {
            this(resourceUri, defer, true);
        }

        public ScriptPositionedInfo(String resourceUri, boolean defer, boolean encodeUrl) {
            super(resourceUri);
            this._defer = defer;
            this._encode = encodeUrl;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getResourceUri()).append(this._defer).append(this._encode).toHashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScriptPositionedInfo) {
                ScriptPositionedInfo other = (ScriptPositionedInfo)obj;
                return new EqualsBuilder().append(this._defer, other._defer).append(this._encode, other._encode).isEquals();
            }
            return false;
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            NonBufferingAddResource.writeJavaScriptReference(response, writer, this.getResourceUri(), this._encode, this._defer);
        }
    }

    private class StylePositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo {
        protected StylePositionedInfo(String resourceUri) {
            super(resourceUri);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            NonBufferingAddResource.writeStyleReference(response, writer, this.getResourceUri());
        }
    }

    private abstract class AbstractResourceUri {
        protected final String _resourceUri;

        protected AbstractResourceUri(String resourceUri) {
            this._resourceUri = resourceUri;
        }

        public int hashCode() {
            return this._resourceUri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof AbstractResourceUri) {
                AbstractResourceUri other = (AbstractResourceUri)obj;
                return this._resourceUri.equals(other._resourceUri);
            }
            return false;
        }

        protected String getResourceUri() {
            return this._resourceUri;
        }
    }

    protected static interface WritablePositionedInfo
    extends PositionedInfo {
        public void writePositionedInfo(HttpServletResponse var1, ResponseWriter var2) throws IOException;
    }

    protected static class AttributeInfo
    implements PositionedInfo {
        private String _attributeName;
        private String _attributeValue;

        protected AttributeInfo() {
        }

        public String getAttributeName() {
            return this._attributeName;
        }

        public void setAttributeName(String attributeName) {
            this._attributeName = attributeName;
        }

        public String getAttributeValue() {
            return this._attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this._attributeValue = attributeValue;
        }
    }

    protected static interface PositionedInfo {
    }
}

