/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.Collections;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.ValueLookup;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.exception.ProcessException;

public class StandardAttributeExpression
implements AttributeExpression {
    private final Query query;
    private final ParameterLookup parameterLookup;

    public StandardAttributeExpression(Query query, ParameterLookup parameterLookup) {
        this.query = query;
        this.parameterLookup = parameterLookup;
    }

    public AttributeExpression.ResultType getResultType() {
        return this.query.getResultType();
    }

    public String evaluate() throws ProcessException {
        return this.evaluate(null, null);
    }

    public String evaluate(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluate(null, decorator);
    }

    public String evaluate(FlowFile flowFile) throws ProcessException {
        return this.evaluate(flowFile, null);
    }

    public String evaluate(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        ValueLookup lookup = new ValueLookup(flowFile, new Map[0]);
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(lookup, Collections.emptyMap(), this.parameterLookup);
        Object evaluationResult = this.query.evaluate(evaluationContext).getValue();
        if (evaluationResult == null) {
            return "";
        }
        String result = evaluationResult.toString();
        if (decorator != null) {
            result = decorator.decorate(result);
        }
        return Query.unescape(result);
    }
}

