/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.analyzer.AbstractInjectionFailureAnalyzer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.MergedAnnotations;

class NotConstructorBoundInjectionFailureAnalyzer
extends AbstractInjectionFailureAnalyzer<NoSuchBeanDefinitionException>
implements Ordered {
    NotConstructorBoundInjectionFailureAnalyzer() {
    }

    public int getOrder() {
        return 0;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, NoSuchBeanDefinitionException cause, String description) {
        InjectionPoint injectionPoint = this.findInjectionPoint(rootFailure);
        if (this.isConstructorBindingConfigurationProperties(injectionPoint)) {
            String simpleName = injectionPoint.getMember().getDeclaringClass().getSimpleName();
            String action = "Update your configuration so that " + simpleName + " is defined via @" + ConfigurationPropertiesScan.class.getSimpleName() + " or @" + EnableConfigurationProperties.class.getSimpleName() + ".";
            return new FailureAnalysis(simpleName + " is annotated with @" + ConstructorBinding.class.getSimpleName() + " but it is defined as a regular bean which caused dependency injection to fail.", action, cause);
        }
        return null;
    }

    private boolean isConstructorBindingConfigurationProperties(InjectionPoint injectionPoint) {
        boolean bl;
        Member member;
        if (injectionPoint != null && (member = injectionPoint.getMember()) instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            bl = this.isConstructorBindingConfigurationProperties(constructor);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isConstructorBindingConfigurationProperties(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        BindMethod bindMethod = ConfigurationPropertiesBean.deduceBindMethod(declaringClass);
        return MergedAnnotations.from(declaringClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(ConfigurationProperties.class) && bindMethod == BindMethod.VALUE_OBJECT;
    }

    private InjectionPoint findInjectionPoint(Throwable failure) {
        UnsatisfiedDependencyException unsatisfiedDependencyException = this.findCause(failure, UnsatisfiedDependencyException.class);
        if (unsatisfiedDependencyException == null) {
            return null;
        }
        return unsatisfiedDependencyException.getInjectionPoint();
    }
}

