/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataServiceDocumentRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.domain.ClientServiceDocument;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataServiceDocumentRequestImpl
extends AbstractODataRetrieveRequest<ClientServiceDocument>
implements ODataServiceDocumentRequest {
    ODataServiceDocumentRequestImpl(ODataClient odataClient, URI uri) {
        super(odataClient, uri);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    @Override
    public ODataRetrieveResponse<ClientServiceDocument> execute() {
        HttpResponse res = this.doExecute();
        return new ODataServiceResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataServiceResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ClientServiceDocument serviceDocument;

        private ODataServiceResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.serviceDocument = null;
        }

        @Override
        public ClientServiceDocument getBody() {
            if (this.serviceDocument == null) {
                try {
                    ResWrap<ServiceDocument> resource = this.odataClient.getDeserializer(ContentType.parse(this.getContentType())).toServiceDocument(this.getRawResponse());
                    this.serviceDocument = this.odataClient.getBinder().getODataServiceDocument(resource.getPayload());
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.serviceDocument;
        }
    }
}

