/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultTypeTagged is the corresponding interface of BACnetFaultTypeTagged
type BACnetFaultTypeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetFaultType
	// IsBACnetFaultTypeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultTypeTagged()
	// CreateBuilder creates a BACnetFaultTypeTaggedBuilder
	CreateBACnetFaultTypeTaggedBuilder() BACnetFaultTypeTaggedBuilder
}

// _BACnetFaultTypeTagged is the data-structure of this message
type _BACnetFaultTypeTagged struct {
	Header BACnetTagHeader
	Value  BACnetFaultType

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetFaultTypeTagged = (*_BACnetFaultTypeTagged)(nil)

// NewBACnetFaultTypeTagged factory function for _BACnetFaultTypeTagged
func NewBACnetFaultTypeTagged(header BACnetTagHeader, value BACnetFaultType, tagNumber uint8, tagClass TagClass) *_BACnetFaultTypeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetFaultTypeTagged must not be nil")
	}
	return &_BACnetFaultTypeTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultTypeTaggedBuilder is a builder for BACnetFaultTypeTagged
type BACnetFaultTypeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetFaultType) BACnetFaultTypeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetFaultTypeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetFaultTypeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetFaultType) BACnetFaultTypeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetFaultTypeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetFaultTypeTaggedBuilder
	// Build builds the BACnetFaultTypeTagged or returns an error if something is wrong
	Build() (BACnetFaultTypeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultTypeTagged
}

// NewBACnetFaultTypeTaggedBuilder() creates a BACnetFaultTypeTaggedBuilder
func NewBACnetFaultTypeTaggedBuilder() BACnetFaultTypeTaggedBuilder {
	return &_BACnetFaultTypeTaggedBuilder{_BACnetFaultTypeTagged: new(_BACnetFaultTypeTagged)}
}

type _BACnetFaultTypeTaggedBuilder struct {
	*_BACnetFaultTypeTagged

	collectedErr []error
}

var _ (BACnetFaultTypeTaggedBuilder) = (*_BACnetFaultTypeTaggedBuilder)(nil)

func (b *_BACnetFaultTypeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetFaultType) BACnetFaultTypeTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetFaultTypeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetFaultTypeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetFaultTypeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetFaultTypeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultTypeTaggedBuilder) WithValue(value BACnetFaultType) BACnetFaultTypeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetFaultTypeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetFaultTypeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetFaultTypeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetFaultTypeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetFaultTypeTaggedBuilder) Build() (BACnetFaultTypeTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetFaultTypeTagged.deepCopy(), nil
}

func (b *_BACnetFaultTypeTaggedBuilder) MustBuild() BACnetFaultTypeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultTypeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultTypeTaggedBuilder().(*_BACnetFaultTypeTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetFaultTypeTaggedBuilder creates a BACnetFaultTypeTaggedBuilder
func (b *_BACnetFaultTypeTagged) CreateBACnetFaultTypeTaggedBuilder() BACnetFaultTypeTaggedBuilder {
	if b == nil {
		return NewBACnetFaultTypeTaggedBuilder()
	}
	return &_BACnetFaultTypeTaggedBuilder{_BACnetFaultTypeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultTypeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetFaultTypeTagged) GetValue() BACnetFaultType {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultTypeTagged(structType any) BACnetFaultTypeTagged {
	if casted, ok := structType.(BACnetFaultTypeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultTypeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultTypeTagged) GetTypeName() string {
	return "BACnetFaultTypeTagged"
}

func (m *_BACnetFaultTypeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetFaultTypeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetFaultTypeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetFaultTypeTagged, error) {
	return BACnetFaultTypeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetFaultTypeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultTypeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultTypeTagged, error) {
		return BACnetFaultTypeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetFaultTypeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetFaultTypeTagged, error) {
	v, err := (&_BACnetFaultTypeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetFaultTypeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetFaultTypeTagged BACnetFaultTypeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultTypeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultTypeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetFaultType](ctx, "value", readBuffer, EnsureType[BACnetFaultType](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetFaultType_NONE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetFaultTypeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultTypeTagged")
	}

	return m, nil
}

func (m *_BACnetFaultTypeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultTypeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetFaultTypeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetFaultTypeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetFaultType](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetFaultTypeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetFaultTypeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetFaultTypeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetFaultTypeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetFaultTypeTagged) IsBACnetFaultTypeTagged() {}

func (m *_BACnetFaultTypeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultTypeTagged) deepCopy() *_BACnetFaultTypeTagged {
	if m == nil {
		return nil
	}
	_BACnetFaultTypeTaggedCopy := &_BACnetFaultTypeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetFaultTypeTaggedCopy
}

func (m *_BACnetFaultTypeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
