/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataSetWriterTransportDataType is the corresponding interface of DataSetWriterTransportDataType
type DataSetWriterTransportDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsDataSetWriterTransportDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataSetWriterTransportDataType()
	// CreateBuilder creates a DataSetWriterTransportDataTypeBuilder
	CreateDataSetWriterTransportDataTypeBuilder() DataSetWriterTransportDataTypeBuilder
}

// _DataSetWriterTransportDataType is the data-structure of this message
type _DataSetWriterTransportDataType struct {
	ExtensionObjectDefinitionContract
}

var _ DataSetWriterTransportDataType = (*_DataSetWriterTransportDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataSetWriterTransportDataType)(nil)

// NewDataSetWriterTransportDataType factory function for _DataSetWriterTransportDataType
func NewDataSetWriterTransportDataType() *_DataSetWriterTransportDataType {
	_result := &_DataSetWriterTransportDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataSetWriterTransportDataTypeBuilder is a builder for DataSetWriterTransportDataType
type DataSetWriterTransportDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() DataSetWriterTransportDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataSetWriterTransportDataType or returns an error if something is wrong
	Build() (DataSetWriterTransportDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataSetWriterTransportDataType
}

// NewDataSetWriterTransportDataTypeBuilder() creates a DataSetWriterTransportDataTypeBuilder
func NewDataSetWriterTransportDataTypeBuilder() DataSetWriterTransportDataTypeBuilder {
	return &_DataSetWriterTransportDataTypeBuilder{_DataSetWriterTransportDataType: new(_DataSetWriterTransportDataType)}
}

type _DataSetWriterTransportDataTypeBuilder struct {
	*_DataSetWriterTransportDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (DataSetWriterTransportDataTypeBuilder) = (*_DataSetWriterTransportDataTypeBuilder)(nil)

func (b *_DataSetWriterTransportDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataSetWriterTransportDataType
}

func (b *_DataSetWriterTransportDataTypeBuilder) WithMandatoryFields() DataSetWriterTransportDataTypeBuilder {
	return b
}

func (b *_DataSetWriterTransportDataTypeBuilder) Build() (DataSetWriterTransportDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DataSetWriterTransportDataType.deepCopy(), nil
}

func (b *_DataSetWriterTransportDataTypeBuilder) MustBuild() DataSetWriterTransportDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataSetWriterTransportDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataSetWriterTransportDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataSetWriterTransportDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateDataSetWriterTransportDataTypeBuilder().(*_DataSetWriterTransportDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDataSetWriterTransportDataTypeBuilder creates a DataSetWriterTransportDataTypeBuilder
func (b *_DataSetWriterTransportDataType) CreateDataSetWriterTransportDataTypeBuilder() DataSetWriterTransportDataTypeBuilder {
	if b == nil {
		return NewDataSetWriterTransportDataTypeBuilder()
	}
	return &_DataSetWriterTransportDataTypeBuilder{_DataSetWriterTransportDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataSetWriterTransportDataType) GetExtensionId() int32 {
	return int32(15600)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataSetWriterTransportDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastDataSetWriterTransportDataType(structType any) DataSetWriterTransportDataType {
	if casted, ok := structType.(DataSetWriterTransportDataType); ok {
		return casted
	}
	if casted, ok := structType.(*DataSetWriterTransportDataType); ok {
		return *casted
	}
	return nil
}

func (m *_DataSetWriterTransportDataType) GetTypeName() string {
	return "DataSetWriterTransportDataType"
}

func (m *_DataSetWriterTransportDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_DataSetWriterTransportDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataSetWriterTransportDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataSetWriterTransportDataType DataSetWriterTransportDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataSetWriterTransportDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataSetWriterTransportDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("DataSetWriterTransportDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataSetWriterTransportDataType")
	}

	return m, nil
}

func (m *_DataSetWriterTransportDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataSetWriterTransportDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataSetWriterTransportDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataSetWriterTransportDataType")
		}

		if popErr := writeBuffer.PopContext("DataSetWriterTransportDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataSetWriterTransportDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataSetWriterTransportDataType) IsDataSetWriterTransportDataType() {}

func (m *_DataSetWriterTransportDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataSetWriterTransportDataType) deepCopy() *_DataSetWriterTransportDataType {
	if m == nil {
		return nil
	}
	_DataSetWriterTransportDataTypeCopy := &_DataSetWriterTransportDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_DataSetWriterTransportDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataSetWriterTransportDataTypeCopy
}

func (m *_DataSetWriterTransportDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
