/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AirConditioningDataSetPlantHvacLevel extends AirConditioningData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte zoneGroup;
  protected final HVACZoneList zoneList;
  protected final HVACModeAndFlags hvacModeAndFlags;
  protected final HVACType hvacType;
  protected final HVACTemperature level;
  protected final HVACRawLevels rawLevel;
  protected final HVACAuxiliaryLevel auxLevel;

  public AirConditioningDataSetPlantHvacLevel(
      AirConditioningCommandTypeContainer commandTypeContainer,
      byte zoneGroup,
      HVACZoneList zoneList,
      HVACModeAndFlags hvacModeAndFlags,
      HVACType hvacType,
      HVACTemperature level,
      HVACRawLevels rawLevel,
      HVACAuxiliaryLevel auxLevel) {
    super(commandTypeContainer);
    this.zoneGroup = zoneGroup;
    this.zoneList = zoneList;
    this.hvacModeAndFlags = hvacModeAndFlags;
    this.hvacType = hvacType;
    this.level = level;
    this.rawLevel = rawLevel;
    this.auxLevel = auxLevel;
  }

  public byte getZoneGroup() {
    return zoneGroup;
  }

  public HVACZoneList getZoneList() {
    return zoneList;
  }

  public HVACModeAndFlags getHvacModeAndFlags() {
    return hvacModeAndFlags;
  }

  public HVACType getHvacType() {
    return hvacType;
  }

  public HVACTemperature getLevel() {
    return level;
  }

  public HVACRawLevels getRawLevel() {
    return rawLevel;
  }

  public HVACAuxiliaryLevel getAuxLevel() {
    return auxLevel;
  }

  @Override
  protected void serializeAirConditioningDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AirConditioningDataSetPlantHvacLevel");

    // Simple Field (zoneGroup)
    writeSimpleField("zoneGroup", zoneGroup, writeByte(writeBuffer, 8));

    // Simple Field (zoneList)
    writeSimpleField("zoneList", zoneList, writeComplex(writeBuffer));

    // Simple Field (hvacModeAndFlags)
    writeSimpleField("hvacModeAndFlags", hvacModeAndFlags, writeComplex(writeBuffer));

    // Simple Field (hvacType)
    writeSimpleEnumField(
        "hvacType",
        "HVACType",
        hvacType,
        writeEnum(HVACType::getValue, HVACType::name, writeUnsignedShort(writeBuffer, 8)));

    // Optional Field (level) (Can be skipped, if the value is null)
    writeOptionalField(
        "level", level, writeComplex(writeBuffer), getHvacModeAndFlags().getIsLevelTemperature());

    // Optional Field (rawLevel) (Can be skipped, if the value is null)
    writeOptionalField(
        "rawLevel", rawLevel, writeComplex(writeBuffer), getHvacModeAndFlags().getIsLevelRaw());

    // Optional Field (auxLevel) (Can be skipped, if the value is null)
    writeOptionalField(
        "auxLevel", auxLevel, writeComplex(writeBuffer), getHvacModeAndFlags().getIsAuxLevelUsed());

    writeBuffer.popContext("AirConditioningDataSetPlantHvacLevel");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AirConditioningDataSetPlantHvacLevel _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (zoneGroup)
    lengthInBits += 8;

    // Simple field (zoneList)
    lengthInBits += zoneList.getLengthInBits();

    // Simple field (hvacModeAndFlags)
    lengthInBits += hvacModeAndFlags.getLengthInBits();

    // Simple field (hvacType)
    lengthInBits += 8;

    // Optional Field (level)
    if (level != null) {
      lengthInBits += level.getLengthInBits();
    }

    // Optional Field (rawLevel)
    if (rawLevel != null) {
      lengthInBits += rawLevel.getLengthInBits();
    }

    // Optional Field (auxLevel)
    if (auxLevel != null) {
      lengthInBits += auxLevel.getLengthInBits();
    }

    return lengthInBits;
  }

  public static AirConditioningDataBuilder staticParseAirConditioningDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AirConditioningDataSetPlantHvacLevel");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte zoneGroup = readSimpleField("zoneGroup", readByte(readBuffer, 8));

    HVACZoneList zoneList =
        readSimpleField(
            "zoneList", readComplex(() -> HVACZoneList.staticParse(readBuffer), readBuffer));

    HVACModeAndFlags hvacModeAndFlags =
        readSimpleField(
            "hvacModeAndFlags",
            readComplex(() -> HVACModeAndFlags.staticParse(readBuffer), readBuffer));

    HVACType hvacType =
        readEnumField(
            "hvacType",
            "HVACType",
            readEnum(HVACType::enumForValue, readUnsignedShort(readBuffer, 8)));

    HVACTemperature level =
        readOptionalField(
            "level",
            readComplex(() -> HVACTemperature.staticParse(readBuffer), readBuffer),
            hvacModeAndFlags.getIsLevelTemperature());

    HVACRawLevels rawLevel =
        readOptionalField(
            "rawLevel",
            readComplex(() -> HVACRawLevels.staticParse(readBuffer), readBuffer),
            hvacModeAndFlags.getIsLevelRaw());

    HVACAuxiliaryLevel auxLevel =
        readOptionalField(
            "auxLevel",
            readComplex(() -> HVACAuxiliaryLevel.staticParse(readBuffer), readBuffer),
            hvacModeAndFlags.getIsAuxLevelUsed());

    readBuffer.closeContext("AirConditioningDataSetPlantHvacLevel");
    // Create the instance
    return new AirConditioningDataSetPlantHvacLevelBuilderImpl(
        zoneGroup, zoneList, hvacModeAndFlags, hvacType, level, rawLevel, auxLevel);
  }

  public static class AirConditioningDataSetPlantHvacLevelBuilderImpl
      implements AirConditioningData.AirConditioningDataBuilder {
    private final byte zoneGroup;
    private final HVACZoneList zoneList;
    private final HVACModeAndFlags hvacModeAndFlags;
    private final HVACType hvacType;
    private final HVACTemperature level;
    private final HVACRawLevels rawLevel;
    private final HVACAuxiliaryLevel auxLevel;

    public AirConditioningDataSetPlantHvacLevelBuilderImpl(
        byte zoneGroup,
        HVACZoneList zoneList,
        HVACModeAndFlags hvacModeAndFlags,
        HVACType hvacType,
        HVACTemperature level,
        HVACRawLevels rawLevel,
        HVACAuxiliaryLevel auxLevel) {
      this.zoneGroup = zoneGroup;
      this.zoneList = zoneList;
      this.hvacModeAndFlags = hvacModeAndFlags;
      this.hvacType = hvacType;
      this.level = level;
      this.rawLevel = rawLevel;
      this.auxLevel = auxLevel;
    }

    public AirConditioningDataSetPlantHvacLevel build(
        AirConditioningCommandTypeContainer commandTypeContainer) {
      AirConditioningDataSetPlantHvacLevel airConditioningDataSetPlantHvacLevel =
          new AirConditioningDataSetPlantHvacLevel(
              commandTypeContainer,
              zoneGroup,
              zoneList,
              hvacModeAndFlags,
              hvacType,
              level,
              rawLevel,
              auxLevel);
      return airConditioningDataSetPlantHvacLevel;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AirConditioningDataSetPlantHvacLevel)) {
      return false;
    }
    AirConditioningDataSetPlantHvacLevel that = (AirConditioningDataSetPlantHvacLevel) o;
    return (getZoneGroup() == that.getZoneGroup())
        && (getZoneList() == that.getZoneList())
        && (getHvacModeAndFlags() == that.getHvacModeAndFlags())
        && (getHvacType() == that.getHvacType())
        && (getLevel() == that.getLevel())
        && (getRawLevel() == that.getRawLevel())
        && (getAuxLevel() == that.getAuxLevel())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getZoneGroup(),
        getZoneList(),
        getHvacModeAndFlags(),
        getHvacType(),
        getLevel(),
        getRawLevel(),
        getAuxLevel());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
