/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION
    extends InformationObjectWithSevenByteTime implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.STEP_POSITION_INFORMATION_WITH_TIME_TAG_CP56TIME2A;
  }

  // Properties.
  protected final ValueWithTransientStateIndication vti;
  protected final QualityDescriptor qds;
  protected final SevenOctetBinaryTime cp56Time2a;

  public InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION(
      int address,
      ValueWithTransientStateIndication vti,
      QualityDescriptor qds,
      SevenOctetBinaryTime cp56Time2a) {
    super(address);
    this.vti = vti;
    this.qds = qds;
    this.cp56Time2a = cp56Time2a;
  }

  public ValueWithTransientStateIndication getVti() {
    return vti;
  }

  public QualityDescriptor getQds() {
    return qds;
  }

  public SevenOctetBinaryTime getCp56Time2a() {
    return cp56Time2a;
  }

  @Override
  protected void serializeInformationObjectWithSevenByteTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION");

    // Simple Field (vti)
    writeSimpleField(
        "vti", vti, writeComplex(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (qds)
    writeSimpleField(
        "qds", qds, writeComplex(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (cp56Time2a)
    writeSimpleField(
        "cp56Time2a",
        cp56Time2a,
        writeComplex(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (vti)
    lengthInBits += vti.getLengthInBits();

    // Simple field (qds)
    lengthInBits += qds.getLengthInBits();

    // Simple field (cp56Time2a)
    lengthInBits += cp56Time2a.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithSevenByteTimeBuilder
      staticParseInformationObjectWithSevenByteTimeBuilder(
          ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
          throws ParseException {
    readBuffer.pullContext("InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ValueWithTransientStateIndication vti =
        readSimpleField(
            "vti",
            readComplex(
                () -> ValueWithTransientStateIndication.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    QualityDescriptor qds =
        readSimpleField(
            "qds",
            readComplex(() -> QualityDescriptor.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    SevenOctetBinaryTime cp56Time2a =
        readSimpleField(
            "cp56Time2a",
            readComplex(() -> SevenOctetBinaryTime.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION");
    // Create the instance
    return new InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATIONBuilderImpl(
        vti, qds, cp56Time2a);
  }

  public static class InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATIONBuilderImpl
      implements InformationObjectWithSevenByteTime.InformationObjectWithSevenByteTimeBuilder {
    private final ValueWithTransientStateIndication vti;
    private final QualityDescriptor qds;
    private final SevenOctetBinaryTime cp56Time2a;

    public InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATIONBuilderImpl(
        ValueWithTransientStateIndication vti,
        QualityDescriptor qds,
        SevenOctetBinaryTime cp56Time2a) {
      this.vti = vti;
      this.qds = qds;
      this.cp56Time2a = cp56Time2a;
    }

    public InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION build(int address) {
      InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION
          informationObjectWithSevenByteTime_STEP_POSITION_INFORMATION =
              new InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION(
                  address, vti, qds, cp56Time2a);
      return informationObjectWithSevenByteTime_STEP_POSITION_INFORMATION;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION)) {
      return false;
    }
    InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION that =
        (InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION) o;
    return (getVti() == that.getVti())
        && (getQds() == that.getQds())
        && (getCp56Time2a() == that.getCp56Time2a())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getVti(), getQds(), getCp56Time2a());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
