/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReadProcessedDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 652;
  }

  // Properties.
  protected final long startTime;
  protected final long endTime;
  protected final double processingInterval;
  protected final List<NodeId> aggregateType;
  protected final AggregateConfiguration aggregateConfiguration;

  public ReadProcessedDetails(
      long startTime,
      long endTime,
      double processingInterval,
      List<NodeId> aggregateType,
      AggregateConfiguration aggregateConfiguration) {
    super();
    this.startTime = startTime;
    this.endTime = endTime;
    this.processingInterval = processingInterval;
    this.aggregateType = aggregateType;
    this.aggregateConfiguration = aggregateConfiguration;
  }

  public long getStartTime() {
    return startTime;
  }

  public long getEndTime() {
    return endTime;
  }

  public double getProcessingInterval() {
    return processingInterval;
  }

  public List<NodeId> getAggregateType() {
    return aggregateType;
  }

  public AggregateConfiguration getAggregateConfiguration() {
    return aggregateConfiguration;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReadProcessedDetails");

    // Simple Field (startTime)
    writeSimpleField("startTime", startTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (endTime)
    writeSimpleField("endTime", endTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (processingInterval)
    writeSimpleField("processingInterval", processingInterval, writeDouble(writeBuffer, 64));

    // Implicit Field (noOfAggregateType) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfAggregateType =
        (int) ((((getAggregateType()) == (null)) ? -(1) : COUNT(getAggregateType())));
    writeImplicitField("noOfAggregateType", noOfAggregateType, writeSignedInt(writeBuffer, 32));

    // Array Field (aggregateType)
    writeComplexTypeArrayField("aggregateType", aggregateType, writeBuffer);

    // Simple Field (aggregateConfiguration)
    writeSimpleField("aggregateConfiguration", aggregateConfiguration, writeComplex(writeBuffer));

    writeBuffer.popContext("ReadProcessedDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReadProcessedDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (startTime)
    lengthInBits += 64;

    // Simple field (endTime)
    lengthInBits += 64;

    // Simple field (processingInterval)
    lengthInBits += 64;

    // Implicit Field (noOfAggregateType)
    lengthInBits += 32;

    // Array field
    if (aggregateType != null) {
      int i = 0;
      for (NodeId element : aggregateType) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= aggregateType.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (aggregateConfiguration)
    lengthInBits += aggregateConfiguration.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ReadProcessedDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long startTime = readSimpleField("startTime", readSignedLong(readBuffer, 64));

    long endTime = readSimpleField("endTime", readSignedLong(readBuffer, 64));

    double processingInterval = readSimpleField("processingInterval", readDouble(readBuffer, 64));

    int noOfAggregateType = readImplicitField("noOfAggregateType", readSignedInt(readBuffer, 32));

    List<NodeId> aggregateType =
        readCountArrayField(
            "aggregateType",
            readComplex(() -> NodeId.staticParse(readBuffer), readBuffer),
            noOfAggregateType);

    AggregateConfiguration aggregateConfiguration =
        readSimpleField(
            "aggregateConfiguration",
            readComplex(
                () ->
                    (AggregateConfiguration)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (950)),
                readBuffer));

    readBuffer.closeContext("ReadProcessedDetails");
    // Create the instance
    return new ReadProcessedDetailsBuilderImpl(
        startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
  }

  public static class ReadProcessedDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long startTime;
    private final long endTime;
    private final double processingInterval;
    private final List<NodeId> aggregateType;
    private final AggregateConfiguration aggregateConfiguration;

    public ReadProcessedDetailsBuilderImpl(
        long startTime,
        long endTime,
        double processingInterval,
        List<NodeId> aggregateType,
        AggregateConfiguration aggregateConfiguration) {
      this.startTime = startTime;
      this.endTime = endTime;
      this.processingInterval = processingInterval;
      this.aggregateType = aggregateType;
      this.aggregateConfiguration = aggregateConfiguration;
    }

    public ReadProcessedDetails build() {
      ReadProcessedDetails readProcessedDetails =
          new ReadProcessedDetails(
              startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
      return readProcessedDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReadProcessedDetails)) {
      return false;
    }
    ReadProcessedDetails that = (ReadProcessedDetails) o;
    return (getStartTime() == that.getStartTime())
        && (getEndTime() == that.getEndTime())
        && (getProcessingInterval() == that.getProcessingInterval())
        && (getAggregateType() == that.getAggregateType())
        && (getAggregateConfiguration() == that.getAggregateConfiguration())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStartTime(),
        getEndTime(),
        getProcessingInterval(),
        getAggregateType(),
        getAggregateConfiguration());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
