/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.header;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecCsv;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecMulti;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecPipes;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecSimple;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecSsv;

public class HeaderCodecsUtils {
    private static final Map<String, HeaderCodec> CODECS = new HashMap<String, HeaderCodec>();

    private HeaderCodecsUtils() {
    }

    public static HeaderCodec find(Parameter.StyleEnum styleEnum, Boolean explode) {
        return CODECS.get(HeaderCodecsUtils.formatName(styleEnum, explode));
    }

    private static String formatName(Parameter.StyleEnum styleEnum, Boolean explode) {
        if (styleEnum == null) {
            return "simple";
        }
        return styleEnum + ":" + (explode != null && explode != false ? "1" : "0");
    }

    static {
        CODECS.put("simple", new HeaderCodecSimple());
        CODECS.put("form:1", new HeaderCodecMulti());
        CODECS.put("form:0", new HeaderCodecCsv());
        CODECS.put("pipeDelimited:0", new HeaderCodecPipes());
        CODECS.put("spaceDelimited:0", new HeaderCodecSsv());
    }
}

