/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.buffer.Buffer;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayTransportContext;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;

public class HighwayServerCodecFilter
extends AbstractFilter
implements ProviderFilter {
    public static final String NAME = "highway-server-codec";

    public String getName() {
        return NAME;
    }

    public int getOrder() {
        return -2000;
    }

    public boolean enabledForTransport(String transport) {
        return "highway".equals(transport);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenCompose(this::decodeRequest)).thenCompose(arg_0 -> ((FilterNode)nextNode).onFilter(arg_0))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Invocation> decodeRequest(Invocation invocation) {
        HighwayTransportContext transportContext = (HighwayTransportContext)invocation.getTransportContext();
        try {
            invocation.getInvocationStageTrace().startProviderDecodeRequest();
            HighwayCodec.decodeRequest(invocation, transportContext.getHeader(), transportContext.getOperationProtobuf(), transportContext.getBodyBuffer());
            invocation.getInvocationStageTrace().finishProviderDecodeRequest();
            return CompletableFuture.completedFuture(invocation);
        }
        catch (Exception e) {
            return AsyncUtils.completeExceptionally((Throwable)e);
        }
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        ResponseHeader header = new ResponseHeader();
        header.setStatusCode(response.getStatusCode());
        header.setReasonPhrase(response.getReasonPhrase());
        header.setContext(invocation.getContext());
        header.fromMultiMap(response.getHeaders());
        HighwayTransportContext transportContext = (HighwayTransportContext)invocation.getTransportContext();
        long msgId = transportContext.getMsgId();
        OperationProtobuf operationProtobuf = transportContext.getOperationProtobuf();
        ResponseRootSerializer bodySchema = operationProtobuf.findResponseRootSerializer(response.getStatusCode());
        try {
            boolean failed = response.getResult() instanceof InvocationException;
            Buffer respBuffer = failed ? HighwayCodec.encodeResponse(msgId, header, bodySchema, ((InvocationException)response.getResult()).getErrorData()) : HighwayCodec.encodeResponse(msgId, header, bodySchema, response.getResult());
            transportContext.setResponseBuffer(respBuffer);
            invocation.onEncodeResponseFinish();
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception e) {
            String msg = String.format("encode response failed, msgId=%d", msgId);
            return AsyncUtils.completeExceptionally((Throwable)new IllegalStateException(msg, e));
        }
    }
}

