/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.pending.jdk.JDK15;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.base.MetadataFetcher;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.base.GeoKeys;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.base.UnitKey;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class GeoEncoder {
    private static final int BIDIMENSIONAL = 2;
    private static final int MATRIX_SIZE = 4;
    private final StoreListeners listeners;
    private String citation;
    private boolean isPseudoProjection;
    private AxisDirection[] axisDirections;
    private CoordinateSystemAxis longitudeAxis;
    private Matrix gridToCRS;
    private boolean isPoint;
    private final EnumMap<UnitKey, Unit<?>> units;
    private final short[] keyDirectory;
    private int keyCount;
    private final double[] doubleParams;
    private int doubleCount;
    private final StringBuilder asciiParams;
    private String citationMainKey;
    private int citationLengthIndex;
    private boolean disableEPSG;

    public GeoEncoder(StoreListeners listeners) {
        this.listeners = listeners;
        this.units = new EnumMap(UnitKey.class);
        this.asciiParams = new StringBuilder(100);
        this.doubleParams = new double[25];
        this.keyDirectory = new short[188];
        this.keyDirectory[0] = 1;
        this.keyDirectory[1] = 1;
        this.keyDirectory[2] = 1;
    }

    public void write(GridGeometry grid, MetadataFetcher<?> metadata) throws FactoryException, TransformException, IncommensurableException, IncompatibleResourceException {
        grid = grid.shiftGridToZeros();
        this.citation = (String)CollectionsExt.first((Iterable)metadata.transformationDimension);
        this.isPoint = CollectionsExt.first((Iterable)metadata.cellGeometry) == CellGeometry.POINT;
        PixelInCell anchor = this.isPoint ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER;
        int[] dimensions = grid.getExtent().getSubspaceDimensions(2);
        GridGeometry horizontal = grid.selectDimensions(dimensions);
        if (grid.isDefined(8)) {
            this.gridToCRS = MathTransforms.getMatrix((MathTransform)horizontal.getGridToCRS(anchor));
            if (this.gridToCRS == null) {
                String message = this.resources().getString((short)36);
                throw new IncompatibleResourceException(message).addAspect("gridToCRS");
            }
        }
        if (!grid.isDefined(1)) {
            this.writeModelType((short)0);
            return;
        }
        CoordinateReferenceSystem crs = horizontal.getCoordinateReferenceSystem();
        this.axisDirections = CoordinateSystems.getSimpleAxisDirections((CoordinateSystem)crs.getCoordinateSystem());
        if (crs instanceof ProjectedCRS) {
            this.writeCRS((ProjectedCRS)crs);
        } else if (crs instanceof GeodeticCRS) {
            this.writeCRS((GeodeticCRS)crs, false);
        } else {
            if (crs instanceof EngineeringCRS) {
                this.writeModelType((short)Short.MAX_VALUE);
                return;
            }
            throw this.unsupportedType((IdentifiedObject)crs);
        }
        CoordinateReferenceSystem fullCRS = grid.getCoordinateReferenceSystem();
        VerticalCRS vertical = CRS.getVerticalComponent((CoordinateReferenceSystem)fullCRS, (boolean)true);
        if (vertical != null) {
            VerticalCS cs = vertical.getCoordinateSystem();
            int verticalDimension = AxisDirections.indexOfColinear((CoordinateSystem)fullCRS.getCoordinateSystem(), (CoordinateSystem)cs);
            if (verticalDimension >= 0 && GeoEncoder.isNotHorizontal(verticalDimension, dimensions)) {
                this.writeCRS(vertical);
                this.axisDirections = Arrays.copyOf(this.axisDirections, 3);
                this.axisDirections[2] = cs.getAxis(0).getDirection();
                if (this.gridToCRS != null) {
                    this.gridToCRS = Matrices.resizeAffine((Matrix)this.gridToCRS, (int)4, (int)4);
                    Matrix more = grid.getLinearGridToCRS(anchor).getMatrix();
                    int translationColumn = more.getNumCol() - 1;
                    for (int i = 0; i < 4; ++i) {
                        int s;
                        switch (i) {
                            default: {
                                s = dimensions[i];
                                break;
                            }
                            case 2: {
                                s = verticalDimension;
                                break;
                            }
                            case 3: {
                                s = translationColumn;
                            }
                        }
                        double value = more.getElement(verticalDimension, s);
                        if (s == verticalDimension && translationColumn > 3) {
                            double[] values = new double[translationColumn - 2];
                            int skip = 0;
                            for (int j = 0; j < values.length; ++j) {
                                if (GeoEncoder.isNotHorizontal(j, dimensions)) {
                                    values[j] = more.getElement(verticalDimension, j + skip);
                                    continue;
                                }
                                ++skip;
                            }
                            value = Math.copySign(MathFunctions.magnitude((double[])values), Arrays.stream(values).sum());
                        }
                        this.gridToCRS.setElement(2, i, value);
                    }
                }
            }
        }
    }

    private static boolean isNotHorizontal(int dimension, int[] horizontal) {
        for (int d : horizontal) {
            if (d != dimension) continue;
            return false;
        }
        return true;
    }

    private void writeModelType(short type) {
        this.writeShort((short)1024, type);
        this.writeShort((short)1025, this.isPoint ? (short)2 : 1);
        if (this.citation != null) {
            this.writeString((short)1026, this.citation);
            this.citation = null;
        }
    }

    private void writeCRS(VerticalCRS crs) throws FactoryException, IncompatibleResourceException {
        if (this.writeEPSG((short)4096, (IdentifiedObject)crs)) {
            this.writeName((short)4097, null, (IdentifiedObject)crs);
            this.addUnits(UnitKey.VERTICAL, (CoordinateSystem)crs.getCoordinateSystem());
            VerticalDatum datum = DatumOrEnsemble.asDatum((VerticalCRS)crs);
            if (this.writeEPSG((short)4098, (IdentifiedObject)datum)) {
                // empty if block
            }
            this.writeUnit(UnitKey.VERTICAL);
        }
    }

    private void writeCRS(GeodeticCRS crs, boolean isBaseCRS) throws FactoryException, IncommensurableException, IncompatibleResourceException {
        short type;
        CoordinateSystem cs = crs.getCoordinateSystem();
        this.longitudeAxis = cs.getAxis(AxisDirections.indexOfColinear((CoordinateSystem)cs, (AxisDirection)AxisDirection.EAST));
        this.addUnits(UnitKey.ANGULAR, cs);
        if (cs instanceof EllipsoidalCS) {
            type = 2;
        } else {
            if (isBaseCRS) {
                String message = this.resources().getString((short)34);
                throw new IncompatibleResourceException(message).addAspect("crs");
            }
            if (cs instanceof CartesianCS) {
                type = 3;
            } else {
                throw this.unsupportedType((IdentifiedObject)cs);
            }
        }
        this.writeModelType(isBaseCRS ? (short)1 : type);
        if (this.writeEPSG((short)2048, (IdentifiedObject)crs)) {
            this.writeName((short)2049, "GCS Name", (IdentifiedObject)(this.isPseudoProjection ? null : crs));
            this.writeDatum(DatumOrEnsemble.asDatum((GeodeticCRS)crs));
        } else if (isBaseCRS) {
            this.writeUnit(UnitKey.ANGULAR);
        }
    }

    private void writeDatum(GeodeticDatum datum) throws FactoryException, IncommensurableException, IncompatibleResourceException {
        if (this.writeEPSG((short)2050, (IdentifiedObject)datum)) {
            this.appendName("Datum", (IdentifiedObject)datum);
            boolean previous = this.disableEPSG;
            this.disableEPSG &= !this.isPseudoProjection;
            double longitude = 0.0;
            PrimeMeridian primem = datum.getPrimeMeridian();
            if (this.writeEPSG((short)2051, (IdentifiedObject)primem)) {
                this.appendName("PrimeM", (IdentifiedObject)datum);
                longitude = primem.getGreenwichLongitude();
            }
            this.disableEPSG = previous;
            this.writeEllipsoid(datum.getEllipsoid());
            if (longitude != 0.0) {
                Unit unit = primem.getAngularUnit();
                UnitConverter c = unit.getConverterToAny(this.units.getOrDefault((Object)UnitKey.ANGULAR, Units.DEGREE));
                this.writeDouble((short)2061, c.convert(longitude));
            }
        }
    }

    private void writeEllipsoid(Ellipsoid ellipsoid) throws FactoryException, IncommensurableException, IncompatibleResourceException {
        Unit axisUnit;
        Unit linearUnit = this.units.putIfAbsent(UnitKey.LINEAR, axisUnit = ellipsoid.getAxisUnit());
        UnitConverter toLinear = axisUnit.getConverterToAny(linearUnit != null ? linearUnit : axisUnit);
        this.writeUnit(UnitKey.LINEAR);
        this.writeUnit(UnitKey.ANGULAR);
        if (this.writeEPSG((short)2056, (IdentifiedObject)ellipsoid)) {
            this.appendName("Ellipsoid", (IdentifiedObject)ellipsoid);
            double axisLength = toLinear.convert(ellipsoid.getSemiMajorAxis());
            this.writeDouble((short)2057, axisLength);
            if (!this.isPseudoProjection) {
                if (ellipsoid.isIvfDefinitive() && !ellipsoid.isSphere()) {
                    this.writeDouble((short)2059, ellipsoid.getInverseFlattening());
                    return;
                }
                axisLength = toLinear.convert(ellipsoid.getSemiMinorAxis());
            }
            this.writeDouble((short)2058, axisLength);
        }
    }

    private boolean writeCRS(ProjectedCRS crs) throws FactoryException, IncommensurableException, IncompatibleResourceException {
        boolean previous = this.disableEPSG;
        Projection projection = crs.getConversionFromBase();
        OperationMethod method = projection.getMethod();
        if (method instanceof MapProjection) {
            this.disableEPSG = this.isPseudoProjection = !method.equals((Object)(method = ((MapProjection)method).sourceOfPseudo()));
        }
        this.writeCRS((GeodeticCRS)crs.getBaseCRS(), true);
        this.disableEPSG = previous;
        if (this.writeEPSG((short)3072, (IdentifiedObject)crs)) {
            this.writeName((short)3073, null, (IdentifiedObject)crs);
            this.addUnits(UnitKey.PROJECTED, (CoordinateSystem)crs.getCoordinateSystem());
            if (this.writeEPSG((short)3074, (IdentifiedObject)projection)) {
                short projCode = this.getGeoCode(0, (IdentifiedObject)method);
                this.writeShort((short)3075, projCode);
                this.writeUnit(UnitKey.PROJECTED);
                switch (projCode) {
                    case 0: 
                    case 32767: {
                        this.missingValue((short)3075);
                        return true;
                    }
                }
            }
            for (GeneralParameterValue p : projection.getParameterValues().values()) {
                short key;
                RuntimeException cause = null;
                GeneralParameterDescriptor descriptor = p.getDescriptor();
                if (p instanceof ParameterValue && (key = this.getGeoCode(1, (IdentifiedObject)descriptor)) != 0 && key != Short.MAX_VALUE) {
                    ParameterValue pv = (ParameterValue)p;
                    UnitKey type = UnitKey.ofProjectionParameter(key);
                    if (type == UnitKey.LINEAR) continue;
                    if (type != UnitKey.NULL) {
                        try {
                            Unit<?> unit = this.units.getOrDefault((Object)type, type.defaultUnit());
                            this.writeDouble(key, unit != null ? pv.doubleValue(unit) : pv.doubleValue());
                            continue;
                        }
                        catch (IllegalArgumentException | IllegalStateException e) {
                            cause = e;
                        }
                    }
                }
                throw this.cannotEncode(1, this.name((IdentifiedObject)descriptor), cause);
            }
        }
        return true;
    }

    private void addUnits(UnitKey main, CoordinateSystem cs) throws IncompatibleResourceException {
        int i = cs.getDimension();
        while (--i >= 0) {
            Unit unit = cs.getAxis(i).getUnit();
            UnitKey type = main.validate(unit);
            if (type != null) {
                Unit previous = this.units.putIfAbsent(type, unit);
                if (previous == null || previous.equals((Object)unit)) continue;
                String message = this.errors().getString((short)55, (Object)this.name((IdentifiedObject)cs));
                throw new IncompatibleResourceException(message).addAspect("crs");
            }
            throw this.cannotEncode(2, unit.toString(), null).addAspect("unit");
        }
    }

    private void writeUnit(UnitKey key) throws IncompatibleResourceException {
        Unit<?> unit = this.units.get((Object)key);
        if (unit != null) {
            short epsg = GeoEncoder.toShortEPSG(Units.getEpsgCode(unit, (boolean)key.isAxis));
            if (epsg != Short.MAX_VALUE) {
                this.writeShort(key.codeKey, epsg);
            } else if (key.scaleKey != 0) {
                this.writeShort(key.codeKey, epsg);
                this.writeDouble(key.scaleKey, Units.toStandardUnit(unit));
            } else {
                throw this.cannotEncode(2, unit.toString(), null).addAspect("unit");
            }
        }
    }

    private void writeName(short key, String type, IdentifiedObject object) {
        String name = IdentifiedObjects.getName((IdentifiedObject)object, null);
        if (name == null) {
            name = "Unnamed";
        }
        this.writeString(key, name);
        this.citationMainKey = type;
        this.citationLengthIndex = this.keyCount * 4 + 2;
    }

    private void appendName(String type, IdentifiedObject object) {
        if (this.isPseudoProjection) {
            return;
        }
        String name = IdentifiedObjects.getName((IdentifiedObject)object, null);
        if (name != null) {
            String value;
            int length;
            int i = this.citationLengthIndex;
            int offset = Short.toUnsignedInt(this.keyDirectory[i + 1]);
            int start = length = Short.toUnsignedInt(this.keyDirectory[i]);
            if (this.citationMainKey != null) {
                value = this.citationMainKey + "=";
                this.asciiParams.insert(offset, value);
                length += value.length();
                this.citationMainKey = null;
            }
            value = "|" + type + "=" + name;
            this.asciiParams.insert(offset + length, value);
            this.keyDirectory[i] = GeoEncoder.toShort(length += value.length());
            int shift = length - start;
            int limit = this.keyCount * 4;
            ++i;
            while (i < limit) {
                if (this.keyDirectory[(i += 4) - 2] != -30799) continue;
                offset = Short.toUnsignedInt(this.keyDirectory[i]);
                this.keyDirectory[i] = GeoEncoder.toShort(offset + shift);
            }
        }
    }

    private short getGeoCode(int type, IdentifiedObject object) throws FactoryException, IncompatibleResourceException {
        if (object == null) {
            return 0;
        }
        Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)object, (Citation)Citations.GEOTIFF);
        NumberFormatException cause = null;
        if (id != null) {
            try {
                return Short.parseShort(id.getCode());
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        throw this.cannotEncode(type, this.name(object), cause);
    }

    private boolean writeEPSG(short key, IdentifiedObject object) throws FactoryException {
        if (object == null) {
            this.writeShort(key, (short)0);
            this.missingValue(key);
            return false;
        }
        short epsg = Short.MAX_VALUE;
        if (!this.disableEPSG) {
            try {
                epsg = GeoEncoder.toShortEPSG(IdentifiedObjects.lookupEPSG((IdentifiedObject)object));
            }
            catch (UnavailableFactoryException e) {
                this.listeners.warning(Level.FINE, null, (Exception)((Object)e));
                this.disableEPSG = true;
            }
        }
        this.writeShort(key, epsg);
        return epsg == Short.MAX_VALUE;
    }

    private static short toShortEPSG(Integer epsg) {
        int c;
        if (epsg != null && (c = epsg.intValue()) >= 1024 && c <= 32766) {
            return (short)c;
        }
        return Short.MAX_VALUE;
    }

    private void writeShort(short key, short value) {
        int i = ++this.keyCount * 4;
        this.keyDirectory[i++] = key;
        this.keyDirectory[++i] = 1;
        this.keyDirectory[++i] = value;
    }

    private void writeDouble(short key, double value) {
        int i = ++this.keyCount * 4;
        this.keyDirectory[i++] = key;
        this.keyDirectory[i++] = -30800;
        this.keyDirectory[i++] = 1;
        this.keyDirectory[i] = GeoEncoder.toShort(this.doubleCount);
        this.doubleParams[this.doubleCount++] = value;
    }

    private void writeString(short key, String value) {
        int i = ++this.keyCount * 4;
        this.keyDirectory[i++] = key;
        this.keyDirectory[i++] = -30799;
        this.keyDirectory[i++] = GeoEncoder.toShort(value.length());
        this.keyDirectory[i] = GeoEncoder.toShort(this.asciiParams.length());
        this.asciiParams.append(value).append('|');
    }

    private static short toShort(int value) {
        if ((value & 0xFFFF0000) == 0) {
            return (short)value;
        }
        throw new ArithmeticException(Errors.format((short)91, (Object)16));
    }

    public short[] keyDirectory() {
        if (this.keyCount == 0) {
            return null;
        }
        this.keyDirectory[3] = (short)this.keyCount;
        return ArraysExt.resize((short[])this.keyDirectory, (int)((this.keyCount + 1) * 4));
    }

    public double[] doubleParams() {
        if (this.doubleCount == 0) {
            return null;
        }
        return ArraysExt.resize((double[])this.doubleParams, (int)this.doubleCount);
    }

    public List<String> asciiParams() {
        return JDK15.isEmpty((CharSequence)this.asciiParams) ? null : List.of(this.asciiParams.toString());
    }

    public double[] modelTransformation() {
        if (this.gridToCRS == null) {
            return null;
        }
        if (this.axisDirections != null) {
            AxisDirection[] target = (AxisDirection[])this.axisDirections.clone();
            target[0] = AxisDirection.EAST;
            target[1] = AxisDirection.NORTH;
            this.gridToCRS = Matrices.createTransform((AxisDirection[])this.axisDirections, (AxisDirection[])target).multiply(this.gridToCRS);
            this.axisDirections = null;
        }
        if (this.longitudeAxis != null) {
            try {
                double max = Units.DEGREE.getConverterToAny(this.longitudeAxis.getUnit()).convert(180.0);
                if (Math.abs(this.longitudeAxis.getMaximumValue() - max) > max / 180.0) {
                    int translationColumn = this.gridToCRS.getNumCol() - 1;
                    double translation = this.gridToCRS.getElement(0, translationColumn);
                    if ((translation = Math.IEEEremainder(translation, 2.0 * max)) == max) {
                        translation = -translation;
                    }
                    this.gridToCRS.setElement(0, translationColumn, translation);
                }
            }
            catch (IncommensurableException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
        double[] cf = new double[16];
        int lastRow = this.gridToCRS.getNumRow() - 1;
        int lastCol = this.gridToCRS.getNumCol() - 1;
        int maxRow = Math.min(lastRow, 3);
        int offset = 0;
        for (int row = 0; row < maxRow; ++row) {
            GeoEncoder.copyRow(this.gridToCRS, row, lastCol, cf, offset);
            offset += 4;
        }
        GeoEncoder.copyRow(this.gridToCRS, lastRow, lastCol, cf, 12);
        return cf;
    }

    private static void copyRow(Matrix gridToCRS, int row, int lastCol, double[] target, int offset) {
        target[offset + 3] = gridToCRS.getElement(row, lastCol);
        int i = Math.min(lastCol, 3);
        while (--i >= 0) {
            target[offset + i] = gridToCRS.getElement(row, i);
        }
    }

    private String name(IdentifiedObject object) {
        return IdentifiedObjects.getDisplayName((IdentifiedObject)object, (Locale)this.listeners.getLocale());
    }

    private Errors errors() {
        return Errors.forLocale((Locale)this.listeners.getLocale());
    }

    private Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }

    private void missingValue(short key) {
        this.listeners.warning(this.resources().getString((short)12, GeoKeys.name(key)));
    }

    private IncompatibleResourceException unsupportedType(IdentifiedObject object) {
        String message = this.resources().getString((short)33, ReferencingUtilities.getInterface((Object)object));
        return new IncompatibleResourceException(message).addAspect("crs");
    }

    private IncompatibleResourceException cannotEncode(int type, String name, Exception cause) {
        String message = this.resources().getString((short)35, type, name);
        return new IncompatibleResourceException(message, (Throwable)cause).addAspect("crs");
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"citation", this.citation});
    }
}

