/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.time.Duration;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class ExtentSelector<T> {
    private GeographicBoundingBox areaOfInterest;
    private Temporal minTOI;
    private Temporal maxTOI;
    private long granularity;
    public boolean alternateOrdering;
    private T best;
    private double largestArea;
    private Duration longestTime;
    private double outsideArea;
    private Duration overtime;
    private double pseudoDistance;
    private double temporalDistance;
    private static final int OVERTIME = 0;
    private static final int TEMPORAL_DISTANCE = 1;
    private static final int OUTSIDE_AREA = 2;
    private static final int PSEUDO_DISTANCE = 3;
    private static final int NONE = 4;

    public ExtentSelector(GeographicBoundingBox aoi, Temporal[] toi) {
        int n;
        this.areaOfInterest = aoi;
        if (toi != null && (n = toi.length) != 0) {
            this.minTOI = toi[0];
            this.maxTOI = toi[n - 1];
        }
    }

    public ExtentSelector(Extent domain) {
        if (!this.setExtentOfInterest(domain, null, null)) {
            throw new IllegalArgumentException();
        }
    }

    public final boolean setExtentOfInterest(Extent domain, GeographicBoundingBox aoi, Temporal[] toi) {
        this.areaOfInterest = Extents.intersection((GeographicBoundingBox)aoi, (GeographicBoundingBox)Extents.getGeographicBoundingBox((Extent)domain));
        this.maxTOI = null;
        this.minTOI = null;
        Range tr = Extents.getTimeRange((Extent)domain);
        if (tr != null) {
            this.minTOI = TemporalDate.toTemporal((Date)((Date)tr.getMinValue()));
            this.maxTOI = TemporalDate.toTemporal((Date)((Date)tr.getMaxValue()));
        }
        if (toi != null && toi.length != 0) {
            Temporal t = toi[0];
            if (this.minTOI == null || t != null && TemporalDate.compare((Temporal)t, (Temporal)this.minTOI) > 0) {
                this.minTOI = t;
            }
            if (toi.length >= 2) {
                t = toi[1];
            }
            if (this.maxTOI == null || t != null && TemporalDate.compare((Temporal)t, (Temporal)this.maxTOI) < 0) {
                this.maxTOI = t;
            }
        }
        return (this.minTOI == null || this.maxTOI == null || TemporalDate.compare((Temporal)this.minTOI, (Temporal)this.maxTOI) <= 0) && (this.areaOfInterest == null || this.areaOfInterest.getNorthBoundLatitude() >= this.areaOfInterest.getSouthBoundLatitude() && Double.isFinite(this.areaOfInterest.getWestBoundLongitude()) && Double.isFinite(this.areaOfInterest.getEastBoundLongitude()) && !Boolean.FALSE.equals(this.areaOfInterest.getInclusion()));
    }

    public final GeographicBoundingBox getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public final Temporal[] getTimeOfInterest() {
        Temporal[] temporalArray;
        if (this.minTOI == null && this.maxTOI == null) {
            temporalArray = null;
        } else {
            Temporal[] temporalArray2 = new Temporal[2];
            temporalArray2[0] = this.minTOI;
            temporalArray = temporalArray2;
            temporalArray2[1] = this.maxTOI;
        }
        return temporalArray;
    }

    public final void setTimeGranularity(Duration resolution) {
        if (resolution == null) {
            this.granularity = 0L;
        } else {
            if (resolution.isZero() || resolution.isNegative()) {
                throw new IllegalArgumentException(Errors.format((short)59, (Object)"resolution", (Object)resolution));
            }
            this.granularity = resolution.getSeconds();
        }
    }

    private Duration round(Duration duration) {
        long t;
        long r;
        if (duration != null && !duration.isZero() && this.granularity != 0L && (r = (t = duration.getSeconds()) % this.granularity) != 0L) {
            if ((t -= r) == 0L || r >= this.granularity >> 1) {
                t += this.granularity;
            }
            duration = Duration.ofSeconds(t);
        }
        return duration;
    }

    private double pseudoDistance(GeographicBoundingBox area) {
        if (this.areaOfInterest == null || area == null) {
            return Double.NaN;
        }
        double c\u03c6 = this.areaOfInterest.getNorthBoundLatitude() + this.areaOfInterest.getSouthBoundLatitude();
        double d\u03c6 = area.getNorthBoundLatitude() + area.getSouthBoundLatitude() - c\u03c6;
        double d\u03bb = (area.getEastBoundLongitude() - this.areaOfInterest.getEastBoundLongitude() + (area.getWestBoundLongitude() - this.areaOfInterest.getWestBoundLongitude())) * Math.cos(c\u03c6 * (Math.PI / 360));
        return d\u03c6 * d\u03c6 + d\u03bb * d\u03bb;
    }

    private double temporalDistance(Temporal startTime, Temporal endTime) {
        return Math.abs(ExtentSelector.median(startTime, endTime) - ExtentSelector.median(this.minTOI, this.maxTOI));
    }

    private static double median(Temporal tmin, Temporal tmax) {
        if (tmin == null) {
            if (tmax == null) {
                return Double.NaN;
            }
            tmin = tmax;
        } else if (tmax == null) {
            tmax = tmin;
        }
        long t0 = tmin.getLong(ChronoField.INSTANT_SECONDS);
        long n0 = tmin.getLong(ChronoField.NANO_OF_SECOND);
        if (tmax != tmin) {
            long t1 = tmax.getLong(ChronoField.INSTANT_SECONDS);
            long n1 = tmax.getLong(ChronoField.NANO_OF_SECOND);
            return MathFunctions.average((long)t0, (long)t1) + MathFunctions.average((long)n0, (long)n1) / 1.0E9;
        }
        return (double)t0 + (double)n0 / 1.0E9;
    }

    private Duration overtime(Temporal startTime, Temporal endTime, Duration intersection) {
        return startTime != null && endTime != null && intersection != null ? this.round(Duration.between(startTime, endTime).minus(intersection)) : null;
    }

    public void evaluate(Extent domain, T object) {
        Range tr = Extents.getTimeRange((Extent)domain);
        this.evaluate(Extents.getGeographicBoundingBox((Extent)domain), tr != null ? TemporalDate.toTemporal((Date)((Date)tr.getMinValue())) : null, tr != null ? TemporalDate.toTemporal((Date)((Date)tr.getMaxValue())) : null, object);
    }

    public void evaluate(GeographicBoundingBox bbox, Temporal startTime, Temporal endTime, T object) {
        int comparison;
        double area;
        Duration duration;
        Temporal tmin = startTime;
        Temporal tmax = endTime;
        if (tmin != null && this.minTOI != null && TemporalDate.compare((Temporal)tmin, (Temporal)this.minTOI) < 0) {
            tmin = this.minTOI;
        }
        if (tmax != null && this.maxTOI != null && TemporalDate.compare((Temporal)tmax, (Temporal)this.maxTOI) > 0) {
            tmax = this.maxTOI;
        }
        if (tmin != null && tmax != null) {
            duration = Duration.between(tmin, tmax);
            if (duration.isNegative()) {
                return;
            }
        } else {
            duration = null;
        }
        if (Double.isNaN(area = Extents.area((GeographicBoundingBox)Extents.intersection((GeographicBoundingBox)bbox, (GeographicBoundingBox)this.areaOfInterest))) && bbox != null) {
            return;
        }
        Duration durationRounded = this.round(duration);
        int remainingFieldsToCompute = 0;
        if (this.best != null && (comparison = ExtentSelector.compare(durationRounded, this.longestTime, -1)) <= 0) {
            if (comparison != 0) {
                return;
            }
            remainingFieldsToCompute = 1;
            Duration et = this.overtime(startTime, endTime, duration);
            comparison = ExtentSelector.compare(et, this.overtime, 1);
            if (comparison >= 0) {
                if (comparison != 0) {
                    return;
                }
                remainingFieldsToCompute = 2;
                double td = this.temporalDistance(startTime, endTime);
                if (this.alternateOrdering || (comparison = ExtentSelector.compare(td, this.temporalDistance, 1)) >= 0) {
                    if (comparison != 0) {
                        return;
                    }
                    comparison = ExtentSelector.compare(area, this.largestArea, -1);
                    if (comparison <= 0) {
                        if (comparison != 0) {
                            return;
                        }
                        remainingFieldsToCompute = 3;
                        double out = Extents.area((GeographicBoundingBox)bbox) - area;
                        comparison = ExtentSelector.compare(out, this.outsideArea, 1);
                        if (comparison >= 0) {
                            if (comparison != 0) {
                                return;
                            }
                            remainingFieldsToCompute = 4;
                            double pd = this.pseudoDistance(bbox);
                            if (!(ExtentSelector.compare(pd, this.pseudoDistance, 1) < 0 || comparison == 0 && this.alternateOrdering)) {
                                return;
                            }
                            if (this.alternateOrdering && ExtentSelector.compare(td, this.temporalDistance, 1) >= 0) {
                                return;
                            }
                            this.pseudoDistance = pd;
                        }
                        this.outsideArea = out;
                    }
                }
                this.temporalDistance = td;
            }
            this.overtime = et;
        }
        this.longestTime = durationRounded;
        this.largestArea = area;
        switch (remainingFieldsToCompute) {
            case 0: {
                this.overtime = this.overtime(startTime, endTime, duration);
            }
            case 1: {
                this.temporalDistance = this.temporalDistance(startTime, endTime);
            }
            case 2: {
                this.outsideArea = Extents.area((GeographicBoundingBox)bbox) - area;
            }
            case 3: {
                this.pseudoDistance = this.pseudoDistance(bbox);
            }
        }
        this.best = object;
    }

    private static int compare(Duration a, Duration b, int missing) {
        if (a != null) {
            return b != null ? a.compareTo(b) : -missing;
        }
        return b != null ? missing : 0;
    }

    private static int compare(double a, double b, int missing) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        boolean n = Double.isNaN(b);
        if (Double.isNaN(a) == n) {
            return 0;
        }
        if (n) {
            missing = -missing;
        }
        return missing;
    }

    public T best() {
        return this.best;
    }
}

