/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import org.apache.sling.cms.core.publication.PublicationPropertyProviderConfig;
import org.apache.sling.cms.publication.PublicationManagerFactory;
import org.apache.sling.discovery.PropertyProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PropertyProvider.class}, property={"instance.properties=pub.endpointPaths", "instance.properties=pub.instanceType"})
@Designate(ocd=PublicationPropertyProviderConfig.class)
public class PublicationPropertyProvider
implements PropertyProvider {
    private static final Logger log = LoggerFactory.getLogger(PublicationPropertyProvider.class);
    public static final String ENDPOINT_PATHS = "pub.endpointPaths";
    public static final String INSTANCE_TYPE = "pub.instanceType";
    @Reference
    private PublicationManagerFactory publicationManagerFactory;
    private PublicationPropertyProviderConfig config;

    @Activate
    public void activate(PublicationPropertyProviderConfig config) {
        log.info("activate");
        this.config = config;
    }

    public String getProperty(String name) {
        log.trace("getProperty({})", (Object)name);
        if (ENDPOINT_PATHS.equals(name)) {
            return this.config.endpointPath();
        }
        if (INSTANCE_TYPE.equals(name)) {
            return this.publicationManagerFactory.getInstanceType().toString();
        }
        return null;
    }
}

